/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.alias;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.providers.IFluidProvider;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.content.gear.IModuleItem;
import mekanism.common.registration.impl.ItemDeferredRegister;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;

public interface RVAliasHelper<ITEM, FLUID, CHEMICAL> {
    public ITEM ingredient(ItemLike var1);

    public ITEM ingredient(ItemStack var1);

    public FLUID ingredient(IFluidProvider var1);

    public FLUID ingredient(FluidStack var1);

    public CHEMICAL ingredient(IChemicalProvider var1);

    default public void addAlias(IHasTranslationKey alias, ItemLike ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Expected to have at least one item");
        }
        this.addItemAliases(Arrays.stream(items).map(this::ingredient).toList(), alias);
    }

    default public void addAliases(IFluidProvider fluidProvider, IChemicalProvider chemicalProvider, IHasTranslationKey ... aliases) {
        this.addAliases(fluidProvider, aliases);
        this.addAliases(chemicalProvider, aliases);
    }

    default public void addAliases(ItemLike item, IHasTranslationKey ... aliases) {
        this.addAliases(new ItemStack(item), aliases);
    }

    default public void addAliases(ItemStack stack, IHasTranslationKey ... aliases) {
        this.addItemAliases(List.of(this.ingredient(stack)), aliases);
    }

    default public void addAliases(Collection<? extends ItemLike> stacks, IHasTranslationKey ... aliases) {
        this.addItemAliases(stacks.stream().map(this::ingredient).toList(), aliases);
    }

    default public void addItemAliases(Collection<ItemStack> stacks, IHasTranslationKey ... aliases) {
        this.addItemAliases(stacks.stream().map(this::ingredient).toList(), aliases);
    }

    default public void addAliases(IFluidProvider fluidProvider, IHasTranslationKey ... aliases) {
        this.addFluidAliases(List.of(this.ingredient(fluidProvider)), aliases);
    }

    default public void addAliases(FluidStack stack, IHasTranslationKey ... aliases) {
        this.addFluidAliases(List.of(this.ingredient(stack)), aliases);
    }

    default public void addAliases(IChemicalProvider chemicalProvider, IHasTranslationKey ... aliases) {
        this.addChemicalAliases(List.of(this.ingredient(chemicalProvider)), aliases);
    }

    default public void addItemAlias(ITEM item, IHasTranslationKey ... aliases) {
        this.addItemAliases(List.of(item), aliases);
    }

    public void addItemAliases(List<ITEM> var1, IHasTranslationKey ... var2);

    default public void addFluidAlias(FLUID fluid, IHasTranslationKey ... aliases) {
        this.addFluidAliases(List.of(fluid), aliases);
    }

    public void addFluidAliases(List<FLUID> var1, IHasTranslationKey ... var2);

    default public void addChemicalAlias(CHEMICAL chemical, IHasTranslationKey ... aliases) {
        this.addChemicalAliases(List.of(chemical), aliases);
    }

    public void addChemicalAliases(List<CHEMICAL> var1, IHasTranslationKey ... var2);

    default public void addModuleAliases(ItemDeferredRegister items) {
        for (DeferredHolder entry : items.getEntries()) {
            Object object = entry.get();
            if (!(object instanceof IModuleItem)) continue;
            IModuleItem module = (IModuleItem)object;
            this.addAliases((ItemLike)entry.get(), (IHasTranslationKey[])IModuleHelper.INSTANCE.getSupported(module.getModuleData()).stream().map(item -> () -> ((Item)item).getDescriptionId()).toArray(IHasTranslationKey[]::new));
        }
    }
}

