/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mekanism.common.lib.math.Pos3D;
import mekanism.common.particle.LaserParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class LaserParticle
extends TextureSheetParticle {
    private static final float RADIAN_45 = (float)Math.toRadians(45.0);
    private static final float RADIAN_90 = (float)Math.toRadians(90.0);
    private final Direction direction;
    private final float halfLength;

    private LaserParticle(ClientLevel world, Vec3 start, Vec3 end, Direction dir, float energyScale) {
        super(world, (start.x + end.x) / 2.0, (start.y + end.y) / 2.0, (start.z + end.z) / 2.0);
        this.lifetime = 5;
        this.rCol = 1.0f;
        this.gCol = 0.0f;
        this.bCol = 0.0f;
        this.alpha = 0.11f;
        this.quadSize = energyScale;
        this.halfLength = (float)(end.distanceTo(start) / 2.0);
        this.direction = dir;
        this.updateBoundingBox();
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public void render(@NotNull VertexConsumer vertexBuilder, Camera renderInfo, float partialTicks) {
        Vec3 view = renderInfo.getPosition();
        float newX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - view.x());
        float newY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - view.y());
        float newZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - view.z());
        float uMin = this.getU0();
        float uMax = this.getU1();
        float vMin = this.getV0();
        float vMax = this.getV1();
        int light = this.getLightColor(partialTicks);
        float quadSize = this.getQuadSize(partialTicks);
        Quaternionf quaternion = this.direction.getRotation();
        quaternion.mul((Quaternionfc)Axis.YP.rotation(RADIAN_45));
        this.drawComponent(vertexBuilder, this.getResultVector(quaternion, newX, newY, newZ, quadSize), uMin, uMax, vMin, vMax, light);
        Quaternionf quaternion2 = new Quaternionf((Quaternionfc)quaternion);
        quaternion2.mul((Quaternionfc)Axis.YP.rotation(RADIAN_90));
        this.drawComponent(vertexBuilder, this.getResultVector(quaternion2, newX, newY, newZ, quadSize), uMin, uMax, vMin, vMax, light);
    }

    private Vector3f[] getResultVector(Quaternionf quaternion, float newX, float newY, float newZ, float quadSize) {
        Vector3f[] resultVector;
        for (Vector3f vec : resultVector = new Vector3f[]{new Vector3f(-quadSize, -this.halfLength, 0.0f), new Vector3f(-quadSize, this.halfLength, 0.0f), new Vector3f(quadSize, this.halfLength, 0.0f), new Vector3f(quadSize, -this.halfLength, 0.0f)}) {
            quaternion.transform(vec);
            vec.add(newX, newY, newZ);
        }
        return resultVector;
    }

    private void drawComponent(VertexConsumer vertexBuilder, Vector3f[] resultVector, float uMin, float uMax, float vMin, float vMax, int light) {
        this.addVertex(vertexBuilder, resultVector[0], uMax, vMax, light);
        this.addVertex(vertexBuilder, resultVector[1], uMax, vMin, light);
        this.addVertex(vertexBuilder, resultVector[2], uMin, vMin, light);
        this.addVertex(vertexBuilder, resultVector[3], uMin, vMax, light);
        this.addVertex(vertexBuilder, resultVector[1], uMax, vMin, light);
        this.addVertex(vertexBuilder, resultVector[0], uMax, vMax, light);
        this.addVertex(vertexBuilder, resultVector[3], uMin, vMax, light);
        this.addVertex(vertexBuilder, resultVector[2], uMin, vMin, light);
    }

    private void addVertex(VertexConsumer vertexBuilder, Vector3f pos, float u, float v, int light) {
        vertexBuilder.addVertex(pos.x(), pos.y(), pos.z()).setUv(u, v).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected void setSize(float particleWidth, float particleHeight) {
        if (particleWidth != this.bbWidth || particleHeight != this.bbHeight) {
            this.bbWidth = particleWidth;
            this.bbHeight = particleHeight;
        }
    }

    public void setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (this.direction != null) {
            this.updateBoundingBox();
        }
    }

    private void updateBoundingBox() {
        float halfDiameter = this.quadSize / 2.0f;
        this.setBoundingBox(switch (this.direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP -> new AABB(this.x - (double)halfDiameter, this.y - (double)this.halfLength, this.z - (double)halfDiameter, this.x + (double)halfDiameter, this.y + (double)this.halfLength, this.z + (double)halfDiameter);
            case Direction.NORTH, Direction.SOUTH -> new AABB(this.x - (double)halfDiameter, this.y - (double)halfDiameter, this.z - (double)this.halfLength, this.x + (double)halfDiameter, this.y + (double)halfDiameter, this.z + (double)this.halfLength);
            case Direction.WEST, Direction.EAST -> new AABB(this.x - (double)this.halfLength, this.y - (double)halfDiameter, this.z - (double)halfDiameter, this.x + (double)this.halfLength, this.y + (double)halfDiameter, this.z + (double)halfDiameter);
        });
    }

    @NotNull
    public AABB getRenderBoundingBox(float partialTicks) {
        return this.getBoundingBox();
    }

    public static class Factory
    implements ParticleProvider<LaserParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public LaserParticle createParticle(LaserParticleData data, @NotNull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Pos3D start = new Pos3D(x, y, z);
            Pos3D end = start.translate(data.direction(), data.distance());
            LaserParticle particleLaser = new LaserParticle(world, start, end, data.direction(), data.energyScale());
            particleLaser.pickSprite(this.spriteSet);
            return particleLaser;
        }
    }
}

