/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class ModelToVoxelShapeUtil {
    public static void main(String[] args) {
        ModelToVoxelShapeUtil.printoutModelFile("/Users/aidancbrady/Documents/Mekanism/src/main/resources/assets/mekanism/models/block/digital_miner.json");
    }

    private static void printoutModelFile(String path) {
        StringBuilder builder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> builder.append((String)s).append('\n'));
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.US);
        DecimalFormat df = new DecimalFormat("#.####", otherSymbols);
        JsonObject obj = JsonParser.parseString((String)builder.toString()).getAsJsonObject();
        if (obj.has("elements")) {
            JsonArray elements = obj.getAsJsonArray("elements");
            ModelToVoxelShapeUtil.printoutObject(elements, df, 0, elements.size());
        } else if (obj.has("children")) {
            JsonObject children = obj.getAsJsonObject("children");
            JsonArray[] childElements = new JsonArray[children.size()];
            int index = 0;
            for (Map.Entry e : children.entrySet()) {
                JsonArray array;
                JsonObject child = ((JsonElement)e.getValue()).getAsJsonObject();
                if (child.has("elements")) {
                    array = child.getAsJsonArray("elements");
                } else {
                    System.err.println("Unable to parse child: " + (String)e.getKey());
                    array = new JsonArray();
                }
                childElements[index++] = array;
            }
            ChildData childData = ChildData.from(childElements);
            int soFar = 0;
            for (JsonArray childElement : childData.childElements) {
                soFar = ModelToVoxelShapeUtil.printoutObject(childElement, df, soFar, childData.totalElements);
            }
        } else {
            System.err.println("Unable to parse model file.");
        }
    }

    private static int printoutObject(JsonArray elementsArray, DecimalFormat df, int soFar, int totalElements) {
        for (JsonElement jsonElement : elementsArray) {
            JsonObject element = jsonElement.getAsJsonObject();
            StringBuilder line = new StringBuilder("box(").append(ModelToVoxelShapeUtil.convertCorner(df, element.getAsJsonArray("from"))).append(", ").append(ModelToVoxelShapeUtil.convertCorner(df, element.getAsJsonArray("to"))).append(')');
            if (++soFar < totalElements) {
                line.append(',');
            }
            if (element.has("name")) {
                line.append(" // ").append(element.get("name").getAsString());
            }
            System.out.println(line);
        }
        return soFar;
    }

    private static String convertCorner(DecimalFormat df, JsonArray corner) {
        return df.format(corner.get(0).getAsDouble()) + ", " + df.format(corner.get(1).getAsDouble()) + ", " + df.format(corner.get(2).getAsDouble());
    }

    private record ChildData(JsonArray[] childElements, int totalElements) {
        private static ChildData from(JsonArray[] childElements) {
            int elements = 0;
            for (JsonArray childElement : childElements) {
                elements += childElement.size();
            }
            return new ChildData(childElements, elements);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildData other = (ChildData)o;
            return this.totalElements == other.totalElements && Arrays.equals(this.childElements, other.childElements);
        }

        @Override
        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.childElements), this.totalElements);
        }
    }
}

