/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MovableFilterButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.gui.element.tab.GuiQIOFrequencyTab;
import mekanism.client.gui.element.window.filter.qio.GuiQIOItemStackFilter;
import mekanism.client.gui.element.window.filter.qio.GuiQIOModIDFilter;
import mekanism.client.gui.element.window.filter.qio.GuiQIOTagFilter;
import mekanism.client.gui.qio.GuiQIOFilerSelect;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.filter.SortableFilterManager;
import mekanism.common.content.qio.IQIOFrequencyHolder;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.qio.filter.QIOModIDFilter;
import mekanism.common.content.qio.filter.QIOTagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiQIOFilterHandler<TILE extends TileEntityQIOFilterHandler>
extends GuiMekanismTile<TILE, MekanismTileContainer<TILE>> {
    private static final int FILTER_COUNT = 3;
    private GuiScrollBar scrollBar;

    static Supplier<List<Component>> getFrequencyText(IQIOFrequencyHolder holder) {
        return () -> {
            QIOFrequency freq = holder.getQIOFrequency();
            if (freq == null) {
                return List.of(MekanismLang.NO_FREQUENCY.translate());
            }
            return List.of(MekanismLang.FREQUENCY.translate(freq.getKey()));
        };
    }

    static Supplier<List<Component>> getFrequencyTooltip(IQIOFrequencyHolder holder) {
        return () -> {
            QIOFrequency freq = holder.getQIOFrequency();
            if (freq == null) {
                return Collections.emptyList();
            }
            return List.of(MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemCount()), TextUtils.format(freq.getTotalItemCountCapacity())), MekanismLang.QIO_TYPES_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemTypes(true)), TextUtils.format(freq.getTotalItemTypeCapacity())));
        };
    }

    public GuiQIOFilterHandler(MekanismTileContainer<TILE> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.imageHeight += 74;
        this.inventoryLabelY = this.imageHeight - 94;
        this.imageWidth += 60;
        this.inventoryLabelX += 30;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiQIOFrequencyTab((IGuiWrapper)this, this.tile));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 9, 16, this.imageWidth - 18, 12, GuiQIOFilterHandler.getFrequencyText((IQIOFrequencyHolder)((Object)this.tile))).tooltip(GuiQIOFilterHandler.getFrequencyTooltip((IQIOFrequencyHolder)((Object)this.tile))));
        this.addRenderableWidget(new GuiElementHolder(this, 9, 30, 204, 68));
        this.addRenderableWidget(new GuiElementHolder(this, 9, 98, 204, 22));
        this.addRenderableWidget(new TranslationButton((IGuiWrapper)this, 10, 99, 202, 20, MekanismLang.BUTTON_NEW_FILTER, (element, mouseX, mouseY) -> {
            GuiQIOFilterHandler gui = (GuiQIOFilterHandler)element.gui();
            gui.addWindow(new GuiQIOFilerSelect(gui, (TileEntityQIOFilterHandler)gui.tile));
            return true;
        }));
        FilterManager filterManager = ((TileEntityQIOFilterHandler)this.tile).getFilterManager();
        this.scrollBar = this.addRenderableWidget(new GuiScrollBar((IGuiWrapper)this, 213, 30, 90, ((SortableFilterManager)filterManager)::count, () -> 3));
        for (int i = 0; i < 3; ++i) {
            this.addRenderableWidget(new MovableFilterButton(this, 10, 31 + i * 22, 202, 22, i, this.scrollBar::getCurrentSelection, filterManager, index -> {
                if (index > 0) {
                    PacketGuiInteract.GuiInteraction interaction = GuiQIOFilterHandler.hasShiftDown() ? PacketGuiInteract.GuiInteraction.MOVE_FILTER_TO_TOP : PacketGuiInteract.GuiInteraction.MOVE_FILTER_UP;
                    PacketUtils.sendToServer(new PacketGuiInteract(interaction, (BlockEntity)this.tile, index));
                }
            }, arg_0 -> this.lambda$addGuiElements$5((SortableFilterManager)filterManager, arg_0), this::onClick, index -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.TOGGLE_FILTER_STATE, (BlockEntity)this.tile, index)), filter -> {
                if (filter != null) {
                    IFilter iFilter = filter;
                    Objects.requireNonNull(iFilter);
                    IFilter selector0$temp = iFilter;
                    int index$1 = 0;
                    return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IItemStackFilter.class, ITagFilter.class, IModIDFilter.class}, (Object)selector0$temp, index$1)) {
                        case 0 -> {
                            IItemStackFilter itemFilter = (IItemStackFilter)selector0$temp;
                            yield List.of(itemFilter.getItemStack());
                        }
                        case 1 -> {
                            ITagFilter tagFilter = (ITagFilter)selector0$temp;
                            String name = tagFilter.getTagName();
                            if (name != null && !name.isEmpty()) {
                                yield TagCache.getItemTagStacks(tagFilter.getTagName());
                            }
                            yield Collections.emptyList();
                        }
                        case 2 -> {
                            IModIDFilter modIDFilter = (IModIDFilter)selector0$temp;
                            yield TagCache.getItemModIDStacks(modIDFilter.getModID());
                        }
                        default -> Collections.emptyList();
                    };
                }
                return Collections.emptyList();
            }));
        }
    }

    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof IItemStackFilter) {
            this.addWindow(GuiQIOItemStackFilter.edit(this, (TileEntityQIOFilterHandler)this.tile, (QIOItemStackFilter)filter));
        } else if (filter instanceof ITagFilter) {
            this.addWindow(GuiQIOTagFilter.edit(this, (TileEntityQIOFilterHandler)this.tile, (QIOTagFilter)filter));
        } else if (filter instanceof IModIDFilter) {
            this.addWindow(GuiQIOModIDFilter.edit(this, (TileEntityQIOFilterHandler)this.tile, (QIOModIDFilter)filter));
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        return super.mouseScrolled(mouseX, mouseY, xDelta, yDelta) || this.scrollBar.adjustScroll(yDelta);
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    private /* synthetic */ void lambda$addGuiElements$5(SortableFilterManager filterManager, int index) {
        if (index < filterManager.count() - 1) {
            PacketGuiInteract.GuiInteraction interaction = GuiQIOFilterHandler.hasShiftDown() ? PacketGuiInteract.GuiInteraction.MOVE_FILTER_TO_BOTTOM : PacketGuiInteract.GuiInteraction.MOVE_FILTER_DOWN;
            PacketUtils.sendToServer(new PacketGuiInteract(interaction, (BlockEntity)this.tile, index));
        }
    }
}

