/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.robit.PacketRobitName;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class GuiRobitRename
extends GuiWindow {
    private final GuiTextField nameChangeField;
    private final EntityRobit robit;

    public GuiRobitRename(IGuiWrapper gui, int x, int y, EntityRobit robit) {
        super(gui, x, y, 172, 58, SelectedWindowData.WindowType.RENAME);
        this.robit = robit;
        this.addChild(new TranslationButton(gui, this.relativeX + 56, this.relativeY + 32, 60, 20, MekanismLang.BUTTON_CONFIRM, (element, mouseX, mouseY) -> this.changeName()));
        this.nameChangeField = this.addChild(new GuiTextField(gui, this, this.relativeX + 21, this.relativeY + 17, this.width - 42, 12));
        this.nameChangeField.setMaxLength(50);
        this.nameChangeField.setCanLoseFocus(false);
        this.nameChangeField.setEnterHandler(this::changeName);
        this.nameChangeField.allowColoredText();
        this.setFocused((GuiEventListener)this.nameChangeField);
    }

    private boolean changeName() {
        String name = this.nameChangeField.getText().trim();
        if (PacketRobitName.hasContent(name)) {
            PacketUtils.sendToServer(new PacketRobitName(this.robit, name));
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)MekanismLang.ROBIT_RENAME.translate(), 7.0f);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return true;
    }

    @Override
    protected boolean isFocusOverlay() {
        return true;
    }
}

