/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.item.GuiDictionary;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerGhostTarget;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.base.TagCache;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiDictionaryTarget
extends GuiElement
implements IRecipeViewerGhostTarget {
    private final Map<GuiDictionary.DictionaryTagType, List<String>> tags = new EnumMap<GuiDictionary.DictionaryTagType, List<String>>(GuiDictionary.DictionaryTagType.class);
    private final Consumer<Set<GuiDictionary.DictionaryTagType>> tagSetter;
    @Nullable
    private Object target;
    @Nullable
    private Tooltip lastTooltip;

    public GuiDictionaryTarget(IGuiWrapper gui, int x, int y, Consumer<Set<GuiDictionary.DictionaryTagType>> tagSetter) {
        super(gui, x, y, 16, 16);
        this.tagSetter = tagSetter;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    private void setTarget(@Nullable Object target) {
        this.target = target;
        this.lastTooltip = target == null || target instanceof ItemStack ? null : TooltipUtils.create((Component)TextComponentUtil.build(this.target));
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Object object = this.target;
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            this.gui().renderItem(guiGraphics, stack, this.relativeX, this.relativeY);
        } else {
            object = this.target;
            if (object instanceof FluidStack) {
                FluidStack stack = (FluidStack)object;
                MekanismRenderer.color(guiGraphics, stack);
                this.drawTiledSprite(guiGraphics, this.relativeX, this.relativeY, this.height, this.width, this.height, MekanismRenderer.getFluidTexture(stack, MekanismRenderer.FluidTextureType.STILL), GuiUtils.TilingDirection.DOWN_RIGHT);
                MekanismRenderer.resetColor(guiGraphics);
            } else {
                object = this.target;
                if (object instanceof ChemicalStack) {
                    ChemicalStack stack = (ChemicalStack)object;
                    MekanismRenderer.color(guiGraphics, stack);
                    this.drawTiledSprite(guiGraphics, this.relativeX, this.relativeY, this.height, this.width, this.height, MekanismRenderer.getChemicalTexture(stack.getChemical()), GuiUtils.TilingDirection.DOWN_RIGHT);
                    MekanismRenderer.resetColor(guiGraphics);
                }
            }
        }
    }

    @Override
    public void renderToolTip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderToolTip(guiGraphics, mouseX, mouseY);
        Object object = this.target;
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            this.gui().renderItemTooltip(guiGraphics, stack, mouseX, mouseY);
        }
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        this.setTooltip(this.lastTooltip);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (Screen.hasShiftDown()) {
            if (this.target != null) {
                this.setTargetSlot(null);
            }
        } else {
            ItemStack stack = this.gui().getCarriedItem();
            if (!stack.isEmpty()) {
                this.setTargetSlot(stack);
            }
        }
    }

    public List<String> getTags(GuiDictionary.DictionaryTagType type) {
        return this.tags.getOrDefault(type, Collections.emptyList());
    }

    public void setTargetSlot(@Nullable Object newTarget) {
        this.tags.clear();
        Object object = newTarget;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemStack.class, FluidStack.class, ChemicalStack.class}, (Object)object, n)) {
            case -1: {
                this.setTarget(null);
                break;
            }
            case 0: {
                IChemicalHandler chemicalHandler;
                IFluidHandlerItem fluidHandler;
                PotionContents potionContents;
                ItemEnchantments enchantments;
                ItemStack itemStack = (ItemStack)object;
                if (itemStack.isEmpty()) {
                    this.setTarget(null);
                    break;
                }
                ItemStack stack = itemStack.copyWithCount(1);
                this.setTarget(stack);
                Item item = stack.getItem();
                this.tags.put(GuiDictionary.DictionaryTagType.ITEM, TagCache.getItemTags(stack));
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    Block block = blockItem.getBlock();
                    this.tags.put(GuiDictionary.DictionaryTagType.BLOCK, TagCache.getTagsAsStrings(block.builtInRegistryHolder()));
                    if (block instanceof IHasTileEntity || block.defaultBlockState().hasBlockEntity()) {
                        this.tags.put(GuiDictionary.DictionaryTagType.BLOCK_ENTITY_TYPE, TagCache.getTileEntityTypeTags(block));
                    }
                }
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                    this.tags.put(GuiDictionary.DictionaryTagType.ENTITY_TYPE, TagCache.getTagsAsStrings(spawnEggItem.getType(stack).getTags()));
                }
                if (!(enchantments = stack.getEnchantments()).isEmpty()) {
                    this.tags.put(GuiDictionary.DictionaryTagType.ENCHANTMENT, TagCache.getTagsAsStrings(enchantments.keySet().stream().flatMap(Holder::tags).distinct()));
                }
                if ((potionContents = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS)) != null) {
                    potionContents.potion().ifPresent(potionHolder -> this.tags.put(GuiDictionary.DictionaryTagType.POTION, TagCache.getTagsAsStrings(potionHolder)));
                    HashSet<String> effectTags = new HashSet<String>();
                    for (MobEffectInstance effect : potionContents.getAllEffects()) {
                        effectTags.addAll(TagCache.getTagsAsStrings(effect.getEffect().tags()));
                    }
                    this.tags.put(GuiDictionary.DictionaryTagType.MOB_EFFECT, List.copyOf(effectTags));
                }
                HashSet attributes = new HashSet();
                BiConsumer<Holder, AttributeModifier> attributeCollector = (holder, modifier) -> attributes.add(holder);
                for (MobEffectInstance slotType : EnumUtils.EQUIPMENT_SLOT_TYPES) {
                    itemStack.forEachModifier((EquipmentSlot)slotType, attributeCollector);
                }
                if (!attributes.isEmpty()) {
                    this.tags.put(GuiDictionary.DictionaryTagType.ATTRIBUTE, TagCache.getTagsAsStrings(attributes.stream().flatMap(Holder::tags).distinct()));
                }
                if ((fluidHandler = Capabilities.FLUID.getCapability(stack)) != null) {
                    this.tags.put(GuiDictionary.DictionaryTagType.FLUID, TagCache.getTagsAsStrings(IntStream.range(0, fluidHandler.getTanks()).mapToObj(arg_0 -> ((IFluidHandlerItem)fluidHandler).getFluidInTank(arg_0)).filter(fluidInTank -> !fluidInTank.isEmpty()).flatMap(FluidStack::getTags).distinct()));
                }
                if ((chemicalHandler = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack)) == null) break;
                this.tags.put(GuiDictionary.DictionaryTagType.CHEMICAL, TagCache.getTagsAsStrings(IntStream.range(0, chemicalHandler.getChemicalTanks()).mapToObj(chemicalHandler::getChemicalInTank).filter(chemicalInTank -> !chemicalInTank.isEmpty()).flatMap(chemicalInTank -> chemicalInTank.getChemical().getTags()).distinct()));
                break;
            }
            case 1: {
                FluidStack fluidStack = (FluidStack)object;
                if (fluidStack.isEmpty()) {
                    this.setTarget(null);
                    break;
                }
                this.setTarget(fluidStack.copy());
                this.tags.put(GuiDictionary.DictionaryTagType.FLUID, TagCache.getTagsAsStrings(fluidStack.getFluidHolder()));
                break;
            }
            case 2: {
                ChemicalStack chemicalStack = (ChemicalStack)object;
                if (chemicalStack.isEmpty()) {
                    this.setTarget(null);
                    break;
                }
                this.setTarget(chemicalStack.copy());
                this.tags.put(GuiDictionary.DictionaryTagType.CHEMICAL, TagCache.getTagsAsStrings(chemicalStack.getChemical().getTags()));
                break;
            }
            default: {
                Mekanism.logger.warn("Unable to get tags for unknown type: {}", newTarget);
                return;
            }
        }
        this.tagSetter.accept(this.tags.keySet());
        GuiDictionaryTarget.playClickSound(BUTTON_CLICK_SOUND);
    }

    @Override
    public boolean hasPersistentData() {
        return true;
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiDictionaryTarget old = (GuiDictionaryTarget)element;
        this.setTarget(old.target);
        this.tags.putAll(old.tags);
    }

    @Override
    @Nullable
    public IRecipeViewerGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return new IRecipeViewerGhostTarget.IGhostIngredientConsumer(){

            @Override
            @Nullable
            public Object supportedTarget(Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    ItemStack stack = (ItemStack)ingredient;
                    return stack.isEmpty() ? null : stack;
                }
                if (ingredient instanceof FluidStack) {
                    FluidStack stack = (FluidStack)ingredient;
                    return stack.isEmpty() ? null : stack;
                }
                if (ingredient instanceof ChemicalStack) {
                    ChemicalStack stack = (ChemicalStack)ingredient;
                    return stack.isEmpty() ? null : stack;
                }
                return null;
            }

            @Override
            public void accept(Object ingredient) {
                GuiDictionaryTarget.this.setTargetSlot(ingredient);
            }
        };
    }
}

