/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.util.function.BooleanSupplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;

public class RadioButton
extends MekanismButton {
    public static final ResourceLocation RADIO = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "radio_button.png");
    public static final int RADIO_SIZE = 8;
    private final Tooltip toggledComponent;
    private final Tooltip altComponent;
    private final BooleanSupplier toggled;

    public RadioButton(IGuiWrapper gui, int x, int y, BooleanSupplier toggled, @NotNull GuiElement.IClickable onPress, Component toggledComponent, Component altComponent) {
        super(gui, x, y, 8, 8, (Component)Component.empty(), onPress);
        this.toggled = toggled;
        this.toggledComponent = TooltipUtils.create(toggledComponent);
        this.altComponent = TooltipUtils.create(altComponent);
        this.clickSound = () -> this.toggled.getAsBoolean() ? (SoundEvent)MekanismSounds.BEEP_OFF.get() : (SoundEvent)MekanismSounds.BEEP_ON.get();
        this.clickVolume = 1.0f;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.toggled.getAsBoolean()) {
            guiGraphics.blit(RADIO, this.getButtonX(), this.getButtonY(), 0.0f, 8.0f, this.getButtonWidth(), this.getButtonHeight(), 16, 16);
        } else {
            int uOffset = this.checkWindows(mouseX, mouseY, this.isHoveredOrFocused()) ? 8 : 0;
            guiGraphics.blit(RADIO, this.getButtonX(), this.getButtonY(), (float)uOffset, 0.0f, this.getButtonWidth(), this.getButtonHeight(), 16, 16);
        }
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        this.setTooltip(this.toggled.getAsBoolean() ? this.toggledComponent : this.altComponent);
    }
}

