/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ColorButton
extends MekanismButton {
    private static final Tooltip NONE = TooltipUtils.create((ILangEntry)MekanismLang.NONE);
    private final Map<EnumColor, Tooltip> tooltips = new EnumMap<EnumColor, Tooltip>(EnumColor.class);
    private final Supplier<EnumColor> colorSupplier;

    public ColorButton(IGuiWrapper gui, int x, int y, int width, int height, Supplier<EnumColor> colorSupplier, @NotNull GuiElement.IClickable onPress, @NotNull GuiElement.IClickable onRightClick) {
        super(gui, x, y, width, height, (Component)Component.empty(), onPress, onRightClick);
        this.colorSupplier = colorSupplier;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        EnumColor color = this.colorSupplier.get();
        if (color != null) {
            guiGraphics.fill(this.getButtonX(), this.getButtonY(), this.getButtonX() + this.getButtonWidth(), this.getButtonY() + this.getButtonHeight(), color.getPackedColor());
        }
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        EnumColor color = this.colorSupplier.get();
        if (color != null) {
            this.setTooltip(this.tooltips.computeIfAbsent(color, c -> TooltipUtils.create(c.getColoredName())));
        } else {
            this.setTooltip(NONE);
        }
    }
}

