/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.inventory.GuiComponents;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiDropdown<TYPE extends Enum<TYPE>>
extends GuiTexturedElement {
    private final Map<TYPE, Tooltip> typeTooltips;
    private final Consumer<TYPE> handler;
    private final Supplier<TYPE> curType;
    private final TYPE[] options;
    @Nullable
    private ScreenRectangle cachedTooltipRect;
    private boolean isOpen;

    public GuiDropdown(IGuiWrapper gui, int x, int y, int width, Class<TYPE> enumClass, Supplier<TYPE> curType, Consumer<TYPE> handler) {
        super(GuiInnerScreen.SCREEN, gui, x, y, width, 12);
        this.curType = curType;
        this.handler = handler;
        this.options = (Enum[])enumClass.getEnumConstants();
        this.typeTooltips = new EnumMap<TYPE, Tooltip>(enumClass);
        this.active = true;
        this.clickSound = MekanismSounds.BEEP_ON;
        this.clickVolume = 1.0f;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        this.setDragging(true);
        this.setOpen(!this.isOpen || mouseY > (double)(this.getY() + 11));
    }

    @Override
    public void onRelease(double mouseX, double mouseY) {
        boolean wasDragging = this.isDragging();
        super.onRelease(mouseX, mouseY);
        if (wasDragging && this.isOpen && mouseY > (double)(this.getY() + 11)) {
            this.handler.accept(this.options[this.getHoveredIndex(mouseX, mouseY)]);
            this.setOpen(false);
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        int maxWidth = this.width - 11;
        Enum current = (Enum)this.curType.get();
        this.drawScaledTextScaledBound(guiGraphics, ((GuiComponents.IDropdownEnum)((Object)current)).getShortName(), this.relativeX + 4, this.relativeY + 2, this.screenTextColor(), maxWidth, 0.8f);
        if (this.isOpen) {
            for (int i = 0; i < this.options.length; ++i) {
                this.drawScaledTextScaledBound(guiGraphics, ((GuiComponents.IDropdownEnum)this.options[i]).getShortName(), this.relativeX + 4, this.relativeY + 11 + 2 + 10 * i, this.screenTextColor(), maxWidth, 0.8f);
            }
        }
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Enum current;
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(guiGraphics, this.getResource(), GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE);
        int index = this.getHoveredIndex(mouseX, mouseY);
        if (index != -1) {
            GuiUtils.drawOutline(guiGraphics, this.relativeX + 1, this.relativeY + 12 + index * 10, this.width - 2, 10, this.screenTextColor());
        }
        if (((GuiComponents.IDropdownEnum)((Object)(current = (Enum)this.curType.get()))).getIcon() != null) {
            guiGraphics.blit(((GuiComponents.IDropdownEnum)((Object)current)).getIcon(), this.relativeX + this.width - 9, this.relativeY + 3, 0.0f, 0.0f, 6, 6, 6, 6);
        }
        if (this.isOpen) {
            for (int i = 0; i < this.options.length; ++i) {
                ResourceLocation icon = ((GuiComponents.IDropdownEnum)this.options[i]).getIcon();
                if (icon == null) continue;
                guiGraphics.blit(icon, this.relativeX + this.width - 9, this.relativeY + 12 + 2 + 10 * i, 0.0f, 0.0f, 6, 6, 6, 6);
            }
        }
    }

    @Override
    @NotNull
    protected ScreenRectangle getTooltipRectangle(int mouseX, int mouseY) {
        return this.cachedTooltipRect == null ? super.getTooltipRectangle(mouseX, mouseY) : this.cachedTooltipRect;
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        int index = this.getHoveredIndex(mouseX, mouseY);
        if (index != -1) {
            Tooltip text = this.typeTooltips.computeIfAbsent(this.options[index], t -> TooltipUtils.create(((GuiComponents.IDropdownEnum)((Object)t)).getTooltip()));
            this.cachedTooltipRect = new ScreenRectangle(this.getX() + 1, this.getY() + 12 + index * 10, this.width - 2, 10);
            this.setTooltip(text);
        } else {
            this.clearTooltip();
            this.cachedTooltipRect = null;
        }
    }

    private int getHoveredIndex(double mouseX, double mouseY) {
        if (this.isOpen && mouseX >= (double)this.getX() && mouseX < (double)this.getRight() && mouseY >= (double)(this.getY() + 11) && mouseY < (double)this.getBottom()) {
            return Math.max(0, Math.min(this.options.length - 1, (int)((mouseY - (double)this.getY() - 11.0) / 10.0)));
        }
        return -1;
    }

    private void setOpen(boolean open) {
        if (this.isOpen != open) {
            this.height = open ? (this.height += this.options.length * 10 + 1) : (this.height -= this.options.length * 10 + 1);
        }
        this.isOpen = open;
    }
}

