/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import mekanism.api.gear.IModule;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.scroll.GuiModuleScrollList;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketRemoveModule;
import mekanism.common.tile.TileEntityModificationStation;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiModificationStation
extends GuiMekanismTile<TileEntityModificationStation, MekanismTileContainer<TileEntityModificationStation>> {
    private IModule<?> selectedModule;
    private MekanismButton removeButton;

    public GuiModificationStation(MekanismTileContainer<TileEntityModificationStation> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.imageHeight += 64;
        this.inventoryLabelY = this.imageHeight - 92;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityModificationStation)this.tile).getEnergyContainer(), 154, 40));
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityModificationStation)this.tile).getEnergyContainer(), ((TileEntityModificationStation)this.tile)::usedEnergy));
        this.addRenderableWidget(new GuiProgress(((TileEntityModificationStation)this.tile)::getScaledProgress, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 65, 123));
        this.removeButton = this.addRenderableWidget(new TranslationButton((IGuiWrapper)this, 34, 96, 108, 17, MekanismLang.BUTTON_REMOVE, (element, mouseX, mouseY) -> {
            GuiModificationStation gui = (GuiModificationStation)element.gui();
            return PacketUtils.sendToServer(new PacketRemoveModule(((TileEntityModificationStation)gui.tile).getBlockPos(), gui.selectedModule.getData(), Screen.hasShiftDown()));
        })).setTooltip(MekanismLang.REMOVE_ALL_MODULES_TOOLTIP);
        this.removeButton.active = this.selectedModule != null;
        this.addRenderableWidget(new GuiModuleScrollList(this, 34, 20, 108, 74, () -> ((TileEntityModificationStation)this.tile).containerSlot.getStack().copy(), this::onModuleSelected));
    }

    private void onModuleSelected(@Nullable IModule<?> module) {
        this.selectedModule = module;
        this.removeButton.active = module != null;
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

