/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.vanilla_input;

import com.mojang.datafixers.util.Either;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.vanilla_input.FluidChemicalRecipeInput;
import net.neoforged.neoforge.fluids.FluidStack;

@NothingNullByDefault
public record RotaryRecipeInput(Either<FluidStack, ChemicalStack> input) implements FluidChemicalRecipeInput
{
    @Override
    public FluidStack getFluid(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("No fluid for index " + index);
        }
        return this.input.left().orElse(FluidStack.EMPTY);
    }

    @Override
    public ChemicalStack getChemical(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("No chemical for index " + index);
        }
        return this.input.right().orElse(ChemicalStack.EMPTY);
    }

    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return (Boolean)this.input.map(FluidStack::isEmpty, ChemicalStack::isEmpty);
    }
}

