/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;

@NothingNullByDefault
public interface IChemicalStackIngredientCreator
extends IIngredientCreator<Chemical, ChemicalStack, ChemicalStackIngredient> {
    @Override
    default public ChemicalStackIngredient from(ChemicalStack instance) {
        Objects.requireNonNull(instance, "ChemicalStackIngredients cannot be created from a null ChemicalStack.");
        return this.from((IChemicalProvider)instance.getChemical(), instance.getAmount());
    }

    @Override
    default public ChemicalStackIngredient from(Chemical instance, int amount) {
        return this.from((IChemicalProvider)instance, (long)amount);
    }

    default public ChemicalStackIngredient from(IChemicalProvider provider, long amount) {
        Objects.requireNonNull(provider, "ChemicalStackIngredients cannot be created from a null chemical provider.");
        return this.from(IngredientCreatorAccess.chemical().of(provider), amount);
    }

    default public ChemicalStackIngredient from(int amount, Chemical ... chemicals) {
        return this.from((long)amount, (IChemicalProvider[])chemicals);
    }

    default public ChemicalStackIngredient from(long amount, IChemicalProvider ... chemicals) {
        if (chemicals.length == 0) {
            throw new IllegalArgumentException("Attempted to create an ChemicalStackIngredients with no chemicals.");
        }
        return this.from(IngredientCreatorAccess.chemical().of(chemicals), amount);
    }

    default public ChemicalStackIngredient fromHolder(Holder<Chemical> instance, long amount) {
        return this.from((IChemicalProvider)instance.value(), amount);
    }

    @Override
    default public ChemicalStackIngredient from(TagKey<Chemical> tag, int amount) {
        return this.from(tag, (long)amount);
    }

    default public ChemicalStackIngredient from(TagKey<Chemical> tag, long amount) {
        Objects.requireNonNull(tag, "ChemicalStackIngredients cannot be created from a null tag.");
        return this.from(IngredientCreatorAccess.chemical().tag(tag), amount);
    }

    public ChemicalStackIngredient from(ChemicalIngredient var1, long var2);
}

