/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.EmptyChemicalIngredient;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;

@NothingNullByDefault
public interface IChemicalIngredientCreator {
    public MapCodec<ChemicalIngredient> singleOrTagCodec();

    public MapCodec<ChemicalIngredient> mapCodecNonEmpty();

    public Codec<List<ChemicalIngredient>> listCodec();

    public Codec<List<ChemicalIngredient>> listCodecNonEmpty();

    public Codec<List<ChemicalIngredient>> listCodecMultipleElements();

    public Codec<ChemicalIngredient> codec();

    public Codec<ChemicalIngredient> codecNonEmpty();

    public StreamCodec<RegistryFriendlyByteBuf, ChemicalIngredient> streamCodec();

    default public ChemicalIngredient empty() {
        return EmptyChemicalIngredient.INSTANCE;
    }

    default public ChemicalIngredient of() {
        return this.empty();
    }

    default public ChemicalIngredient of(ChemicalStack stack) {
        return this.of((IChemicalProvider)stack.getChemical());
    }

    default public ChemicalIngredient of(IChemicalProvider chemicalProvider) {
        return this.of(chemicalProvider.getChemical().getAsHolder());
    }

    public ChemicalIngredient of(Holder<Chemical> var1);

    public ChemicalIngredient tag(TagKey<Chemical> var1);

    default public ChemicalIngredient of(ChemicalStack ... chemicals) {
        return this.of(Arrays.stream(chemicals).map(ChemicalStack::getChemical));
    }

    default public ChemicalIngredient of(IChemicalProvider ... chemicalProviders) {
        return this.of(Arrays.stream(chemicalProviders));
    }

    default public ChemicalIngredient of(Stream<? extends IChemicalProvider> chemicalProviders) {
        return this.ofIngredients(chemicalProviders.map(this::of));
    }

    default public ChemicalIngredient ofIngredients(ChemicalIngredient ... children) {
        if (children.length == 0) {
            return this.empty();
        }
        if (children.length == 1) {
            return children[0];
        }
        return this.compound(List.of(children));
    }

    default public ChemicalIngredient ofIngredients(List<? extends ChemicalIngredient> children) {
        if (children.isEmpty()) {
            return this.empty();
        }
        if (children.size() == 1) {
            return children.getFirst();
        }
        return this.compound(List.copyOf(children));
    }

    default public ChemicalIngredient ofIngredients(Stream<? extends ChemicalIngredient> children) {
        return this.ofIngredients(children.toList());
    }

    public ChemicalIngredient compound(List<ChemicalIngredient> var1);

    public ChemicalIngredient difference(ChemicalIngredient var1, ChemicalIngredient var2);

    public ChemicalIngredient intersection(ChemicalIngredient ... var1);

    public ChemicalIngredient intersection(List<? extends ChemicalIngredient> var1);

    default public ChemicalIngredient intersection(Stream<? extends ChemicalIngredient> ingredients) {
        return this.intersection(ingredients.toList());
    }
}

