/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BasicRotaryRecipe
extends RotaryRecipe {
    protected final ChemicalStackIngredient chemicalInput;
    protected final FluidStackIngredient fluidInput;
    protected final FluidStack fluidOutput;
    protected final ChemicalStack chemicalOutput;
    protected final boolean hasChemicalToFluid;
    protected final boolean hasFluidToChemical;

    public BasicRotaryRecipe(FluidStackIngredient fluidInput, ChemicalStack chemicalOutput) {
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        Objects.requireNonNull(chemicalOutput, "Chemical output cannot be null.");
        if (chemicalOutput.isEmpty()) {
            throw new IllegalArgumentException("Chemical output cannot be empty.");
        }
        this.chemicalOutput = chemicalOutput.copy();
        this.chemicalInput = null;
        this.fluidOutput = FluidStack.EMPTY;
        this.hasChemicalToFluid = false;
        this.hasFluidToChemical = true;
    }

    public BasicRotaryRecipe(ChemicalStackIngredient chemicalInput, FluidStack fluidOutput) {
        this.chemicalInput = Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        Objects.requireNonNull(fluidOutput, "Fluid output cannot be null.");
        if (fluidOutput.isEmpty()) {
            throw new IllegalArgumentException("Fluid output cannot be empty.");
        }
        this.fluidOutput = fluidOutput.copy();
        this.fluidInput = null;
        this.chemicalOutput = ChemicalStack.EMPTY;
        this.hasChemicalToFluid = true;
        this.hasFluidToChemical = false;
    }

    public BasicRotaryRecipe(FluidStackIngredient fluidInput, ChemicalStackIngredient chemicalInput, ChemicalStack chemicalOutput, FluidStack fluidOutput) {
        this.chemicalInput = Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        Objects.requireNonNull(chemicalOutput, "Chemical output cannot be null.");
        Objects.requireNonNull(fluidOutput, "Fluid output cannot be null.");
        if (chemicalOutput.isEmpty()) {
            throw new IllegalArgumentException("Chemical output cannot be empty.");
        }
        if (fluidOutput.isEmpty()) {
            throw new IllegalArgumentException("Fluid output cannot be empty.");
        }
        this.chemicalOutput = chemicalOutput.copy();
        this.fluidOutput = fluidOutput.copy();
        this.hasChemicalToFluid = true;
        this.hasFluidToChemical = true;
    }

    @Override
    public boolean hasChemicalToFluid() {
        return this.hasChemicalToFluid;
    }

    @Override
    public boolean hasFluidToChemical() {
        return this.hasFluidToChemical;
    }

    protected void assertHasChemicalToFluid() {
        if (!this.hasChemicalToFluid()) {
            throw new IllegalStateException("This recipe has no chemical to fluid conversion.");
        }
    }

    protected void assertHasFluidToChemical() {
        if (!this.hasFluidToChemical()) {
            throw new IllegalStateException("This recipe has no fluid to chemical conversion.");
        }
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        return this.hasFluidToChemical() && this.fluidInput.test(fluidStack);
    }

    @Override
    public boolean test(ChemicalStack chemicalStack) {
        return this.hasChemicalToFluid() && this.chemicalInput.test(chemicalStack);
    }

    @Override
    public FluidStackIngredient getFluidInput() {
        this.assertHasFluidToChemical();
        return this.fluidInput;
    }

    @Override
    public ChemicalStackIngredient getChemicalInput() {
        this.assertHasChemicalToFluid();
        return this.chemicalInput;
    }

    @Override
    public List<ChemicalStack> getChemicalOutputDefinition() {
        this.assertHasFluidToChemical();
        return Collections.singletonList(this.chemicalOutput);
    }

    @Override
    public List<FluidStack> getFluidOutputDefinition() {
        this.assertHasChemicalToFluid();
        return Collections.singletonList(this.fluidOutput);
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public ChemicalStack getChemicalOutput(FluidStack input) {
        this.assertHasFluidToChemical();
        return this.chemicalOutput.copy();
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public FluidStack getFluidOutput(ChemicalStack input) {
        this.assertHasChemicalToFluid();
        return this.fluidOutput.copy();
    }

    @Nullable
    public ChemicalStackIngredient getChemicalInputRaw() {
        return this.chemicalInput;
    }

    public ChemicalStack getChemicalOutputRaw() {
        return this.chemicalOutput;
    }

    @Nullable
    public FluidStackIngredient getFluidInputRaw() {
        return this.fluidInput;
    }

    public FluidStack getFluidOutputRaw() {
        return this.fluidOutput;
    }

    public RecipeSerializer<BasicRotaryRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.ROTARY.get();
    }
}

