/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public class BasicPressurizedReactionRecipe
extends PressurizedReactionRecipe {
    protected final ItemStackIngredient inputSolid;
    protected final FluidStackIngredient inputFluid;
    protected final ChemicalStackIngredient inputChemical;
    protected final long energyRequired;
    protected final int duration;
    protected final ItemStack outputItem;
    protected final ChemicalStack outputChemical;

    public BasicPressurizedReactionRecipe(ItemStackIngredient inputSolid, FluidStackIngredient inputFluid, ChemicalStackIngredient inputChemical, long energyRequired, int duration, ItemStack outputItem, ChemicalStack outputChemical) {
        this.inputSolid = Objects.requireNonNull(inputSolid, "Item input cannot be null.");
        this.inputFluid = Objects.requireNonNull(inputFluid, "Fluid input cannot be null.");
        this.inputChemical = Objects.requireNonNull(inputChemical, "Chemical input cannot be null.");
        Preconditions.checkArgument((energyRequired >= 0L ? 1 : 0) != 0, (Object)"Energy required must not be negative");
        this.energyRequired = energyRequired;
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be positive.");
        }
        this.duration = duration;
        Objects.requireNonNull(outputItem, "Item output cannot be null.");
        Objects.requireNonNull(outputChemical, "Chemical output cannot be null.");
        if (outputItem.isEmpty() && outputChemical.isEmpty()) {
            throw new IllegalArgumentException("At least one output must not be empty.");
        }
        this.outputItem = outputItem.copy();
        this.outputChemical = outputChemical.copy();
    }

    @Override
    public ItemStackIngredient getInputSolid() {
        return this.inputSolid;
    }

    @Override
    public FluidStackIngredient getInputFluid() {
        return this.inputFluid;
    }

    @Override
    public ChemicalStackIngredient getInputChemical() {
        return this.inputChemical;
    }

    @Override
    public long getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public boolean test(ItemStack solid, FluidStack liquid, ChemicalStack chemical) {
        return this.inputSolid.test(solid) && this.inputFluid.test(liquid) && this.inputChemical.test(chemical);
    }

    @Override
    public List<PressurizedReactionRecipe.PressurizedReactionRecipeOutput> getOutputDefinition() {
        return Collections.singletonList(new PressurizedReactionRecipe.PressurizedReactionRecipeOutput(this.outputItem, this.outputChemical));
    }

    @Override
    @Contract(value="_, _, _ -> new", pure=true)
    public PressurizedReactionRecipe.PressurizedReactionRecipeOutput getOutput(ItemStack solid, FluidStack liquid, ChemicalStack chemical) {
        return new PressurizedReactionRecipe.PressurizedReactionRecipeOutput(this.outputItem.copy(), this.outputChemical.copy());
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public ChemicalStack getOutputChemical() {
        return this.outputChemical;
    }

    public RecipeSerializer<BasicPressurizedReactionRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.REACTION.get();
    }
}

