/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public class BasicElectrolysisRecipe
extends ElectrolysisRecipe {
    protected final FluidStackIngredient input;
    protected final ChemicalStack leftChemicalOutput;
    protected final ChemicalStack rightChemicalOutput;
    protected final long energyMultiplier;

    public BasicElectrolysisRecipe(FluidStackIngredient input, long energyMultiplier, ChemicalStack leftChemicalOutput, ChemicalStack rightChemicalOutput) {
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        this.energyMultiplier = energyMultiplier;
        if (energyMultiplier < 1L) {
            throw new IllegalArgumentException("Energy multiplier must be at least one.");
        }
        Objects.requireNonNull(leftChemicalOutput, "Left output cannot be null");
        Objects.requireNonNull(rightChemicalOutput, "Right output cannot be null");
        if (leftChemicalOutput.isEmpty()) {
            throw new IllegalArgumentException("Left output cannot be empty.");
        }
        if (rightChemicalOutput.isEmpty()) {
            throw new IllegalArgumentException("Right output cannot be empty.");
        }
        this.leftChemicalOutput = leftChemicalOutput.copy();
        this.rightChemicalOutput = rightChemicalOutput.copy();
    }

    @Override
    public FluidStackIngredient getInput() {
        return this.input;
    }

    @Override
    public List<ElectrolysisRecipe.ElectrolysisRecipeOutput> getOutputDefinition() {
        return Collections.singletonList(new ElectrolysisRecipe.ElectrolysisRecipeOutput(this.leftChemicalOutput, this.rightChemicalOutput));
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        return this.input.test(fluidStack);
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public ElectrolysisRecipe.ElectrolysisRecipeOutput getOutput(FluidStack input) {
        return new ElectrolysisRecipe.ElectrolysisRecipeOutput(this.leftChemicalOutput.copy(), this.rightChemicalOutput.copy());
    }

    @Override
    public long getEnergyMultiplier() {
        return this.energyMultiplier;
    }

    public String getGroup() {
        return "electrolytic_separator";
    }

    public ChemicalStack getLeftChemicalOutput() {
        return this.leftChemicalOutput;
    }

    public ChemicalStack getRightChemicalOutput() {
        return this.rightChemicalOutput;
    }

    public RecipeSerializer<BasicElectrolysisRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.SEPARATING.get();
    }
}

