/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class BasicChemicalToChemicalRecipe
extends ChemicalToChemicalRecipe {
    private final RecipeType<ChemicalToChemicalRecipe> recipeType;
    protected final ChemicalStack output;
    private final ChemicalStackIngredient input;

    public BasicChemicalToChemicalRecipe(ChemicalStackIngredient input, ChemicalStack output, RecipeType<ChemicalToChemicalRecipe> recipeType) {
        this.recipeType = Objects.requireNonNull(recipeType, "Recipe type cannot be null");
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    public final RecipeType<ChemicalToChemicalRecipe> getType() {
        return this.recipeType;
    }

    @Override
    public boolean test(ChemicalStack chemicalStack) {
        return this.input.test(chemicalStack);
    }

    @Override
    public ChemicalStackIngredient getInput() {
        return this.input;
    }

    @Override
    public List<ChemicalStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public ChemicalStack getOutput(ChemicalStack input) {
        return this.output.copy();
    }

    public ChemicalStack getOutputRaw() {
        return this.output;
    }
}

