/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.ItemStackToItemStackRecipe;
import mekanism.api.recipes.basic.BasicCrushingRecipe;
import mekanism.api.recipes.basic.BasicEnrichingRecipe;
import mekanism.api.recipes.basic.BasicSmeltingRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@NothingNullByDefault
public class ItemStackToItemStackRecipeBuilder
extends MekanismRecipeBuilder<ItemStackToItemStackRecipeBuilder> {
    private final Factory factory;
    private final ItemStackIngredient input;
    private final ItemStack output;

    protected ItemStackToItemStackRecipeBuilder(ItemStackIngredient input, ItemStack output, Factory factory) {
        this.input = input;
        this.output = output;
        this.factory = factory;
    }

    public static ItemStackToItemStackRecipeBuilder crushing(ItemStackIngredient input, ItemStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This crushing recipe requires a non empty item output.");
        }
        return new ItemStackToItemStackRecipeBuilder(input, output, BasicCrushingRecipe::new);
    }

    public static ItemStackToItemStackRecipeBuilder enriching(ItemStackIngredient input, ItemStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This enriching recipe requires a non empty item output.");
        }
        return new ItemStackToItemStackRecipeBuilder(input, output, BasicEnrichingRecipe::new);
    }

    public static ItemStackToItemStackRecipeBuilder smelting(ItemStackIngredient input, ItemStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This smelting recipe requires a non empty item output.");
        }
        return new ItemStackToItemStackRecipeBuilder(input, output, BasicSmeltingRecipe::new);
    }

    protected ItemStackToItemStackRecipe asRecipe() {
        return this.factory.create(this.input, this.output);
    }

    public void build(RecipeOutput recipeOutput) {
        this.build(recipeOutput, (ItemLike)this.output.getItem());
    }

    @FunctionalInterface
    public static interface Factory {
        public ItemStackToItemStackRecipe create(ItemStackIngredient var1, ItemStack var2);
    }
}

