/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.attribute;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ITooltipHelper;
import net.minecraft.network.chat.Component;

public class ChemicalAttributes {
    private ChemicalAttributes() {
    }

    public static class Fuel
    extends ChemicalAttribute {
        private final IntSupplier burnTicks;
        private final LongSupplier energyDensity;

        public Fuel(int burnTicks, long energyDensity) {
            if (burnTicks <= 0) {
                throw new IllegalArgumentException("Fuel attributes must burn for at least one tick! Burn Ticks: " + burnTicks);
            }
            if (energyDensity <= 0L) {
                throw new IllegalArgumentException("Fuel attributes must have an energy density greater than zero!");
            }
            if (energyDensity / (long)burnTicks == 0L) {
                throw new IllegalArgumentException("Energy density per tick must be greater than zero! (integer division)");
            }
            this.burnTicks = () -> burnTicks;
            this.energyDensity = () -> energyDensity;
        }

        public Fuel(IntSupplier burnTicks, LongSupplier energyDensity) {
            this.burnTicks = burnTicks;
            this.energyDensity = energyDensity;
        }

        public int getBurnTicks() {
            return this.burnTicks.getAsInt();
        }

        public long getEnergyPerTick() {
            int ticks = this.getBurnTicks();
            if (ticks < 1) {
                MekanismAPI.logger.warn("Invalid tick count ({}) for Fuel attribute, this number should be at least 1.", (Object)ticks);
                return 0L;
            }
            if (ticks == 1) {
                return this.energyDensity.getAsLong();
            }
            return this.energyDensity.getAsLong() / (long)ticks;
        }

        @Override
        @Deprecated(since="10.7.4", forRemoval=true)
        public List<Component> addTooltipText(List<Component> list) {
            this.collectTooltips(list::add);
            return list;
        }

        @Override
        public void collectTooltips(Consumer<Component> adder) {
            ITooltipHelper tooltipHelper = ITooltipHelper.INSTANCE;
            adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_FUEL_BURN_TICKS.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getFormattedNumber(this.getBurnTicks())));
            adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_FUEL_ENERGY_DENSITY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getEnergyPerMBDisplayShort(this.energyDensity.getAsLong())));
        }
    }

    public static non-sealed class HeatedCoolant
    extends Coolant {
        private final IChemicalProvider cooledChemical;

        public HeatedCoolant(IChemicalProvider cooledChemical, double thermalEnthalpy, double conductivity) {
            super(thermalEnthalpy, conductivity);
            this.cooledChemical = cooledChemical;
        }

        public Chemical getCooledChemical() {
            return this.cooledChemical.getChemical();
        }
    }

    public static non-sealed class CooledCoolant
    extends Coolant {
        private final IChemicalProvider heatedChemical;

        public CooledCoolant(IChemicalProvider heatedChemical, double thermalEnthalpy, double conductivity) {
            super(thermalEnthalpy, conductivity);
            this.heatedChemical = heatedChemical;
        }

        public Chemical getHeatedChemical() {
            return this.heatedChemical.getChemical();
        }
    }

    public static abstract sealed class Coolant
    extends ChemicalAttribute
    permits CooledCoolant, HeatedCoolant {
        private final double thermalEnthalpy;
        private final double conductivity;

        private Coolant(double thermalEnthalpy, double conductivity) {
            if (thermalEnthalpy <= 0.0) {
                throw new IllegalArgumentException("Coolant attributes must have a thermal enthalpy greater than zero! Thermal Enthalpy: " + thermalEnthalpy);
            }
            if (conductivity <= 0.0 || conductivity > 1.0) {
                throw new IllegalArgumentException("Coolant attributes must have a conductivity greater than zero and at most one! Conductivity: " + conductivity);
            }
            this.thermalEnthalpy = thermalEnthalpy;
            this.conductivity = conductivity;
        }

        public double getThermalEnthalpy() {
            return this.thermalEnthalpy;
        }

        public double getConductivity() {
            return this.conductivity;
        }

        @Override
        @Deprecated(since="10.7.4", forRemoval=true)
        public List<Component> addTooltipText(List<Component> list) {
            this.collectTooltips(list::add);
            return list;
        }

        @Override
        public void collectTooltips(Consumer<Component> adder) {
            ITooltipHelper tooltipHelper = ITooltipHelper.INSTANCE;
            adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_COOLANT_EFFICIENCY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getPercent(this.conductivity)));
            adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_COOLANT_ENTHALPY.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getEnergyPerMBDisplayShort(MathUtils.clampToLong(this.thermalEnthalpy))));
        }
    }

    public static class Radiation
    extends ChemicalAttribute {
        private final double radioactivity;

        public Radiation(double radioactivity) {
            if (radioactivity <= 0.0) {
                throw new IllegalArgumentException("Radiation attribute should only be used when there actually is radiation! Radioactivity: " + radioactivity);
            }
            this.radioactivity = radioactivity;
        }

        public double getRadioactivity() {
            return this.radioactivity;
        }

        @Override
        public boolean needsValidation() {
            return IRadiationManager.INSTANCE.isRadiationEnabled();
        }

        @Override
        @Deprecated(since="10.7.4", forRemoval=true)
        public List<Component> addTooltipText(List<Component> list) {
            this.collectTooltips(list::add);
            return list;
        }

        @Override
        public void collectTooltips(Consumer<Component> adder) {
            if (this.needsValidation()) {
                ITooltipHelper tooltipHelper = ITooltipHelper.INSTANCE;
                adder.accept((Component)APILang.CHEMICAL_ATTRIBUTE_RADIATION.translateColored(EnumColor.GRAY, EnumColor.INDIGO, tooltipHelper.getRadioactivityDisplayShort(this.getRadioactivity())));
            }
        }
    }
}

