/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.IChemicalAttributeContainer;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class ChemicalStack
implements IHasTextComponent,
IHasTranslationKey,
IChemicalAttributeContainer<ChemicalStack> {
    public static final ChemicalStack EMPTY = new ChemicalStack(null);
    public static final Codec<Chemical> CHEMICAL_NON_EMPTY_CODEC = Chemical.CODEC.validate(chemical -> chemical.isEmptyType() ? DataResult.error(() -> "Chemical must not be mekanism:empty") : DataResult.success((Object)chemical));
    public static final Codec<Holder<Chemical>> CHEMICAL_NON_EMPTY_HOLDER_CODEC = MekanismAPI.CHEMICAL_REGISTRY.holderByNameCodec().validate(chemical -> ((Chemical)chemical.value()).isEmptyType() ? DataResult.error(() -> "Chemical must not be mekanism:empty") : DataResult.success((Object)chemical));
    public static final MapCodec<ChemicalStack> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CHEMICAL_NON_EMPTY_CODEC.fieldOf("id").forGetter(ChemicalStack::getChemical), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStack::getAmount)).apply((Applicative)instance, ChemicalStack::new));
    public static final Codec<ChemicalStack> CODEC = MAP_CODEC.codec();
    public static final Codec<ChemicalStack> OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(optional -> optional.orElse(EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalStack> OPTIONAL_STREAM_CODEC = (StreamCodec)Util.make(() -> {
        final StreamCodec chemicalStreamCodec = ByteBufCodecs.registry(MekanismAPI.CHEMICAL_REGISTRY_NAME);
        return new StreamCodec<RegistryFriendlyByteBuf, ChemicalStack>(){

            public ChemicalStack decode(RegistryFriendlyByteBuf buffer) {
                long amount = buffer.readVarLong();
                if (amount <= 0L) {
                    return EMPTY;
                }
                Chemical chemical = (Chemical)chemicalStreamCodec.decode((Object)buffer);
                return new ChemicalStack(chemical, amount);
            }

            public void encode(RegistryFriendlyByteBuf buffer, ChemicalStack stack) {
                buffer.writeVarLong(stack.getAmount());
                if (!stack.isEmpty()) {
                    chemicalStreamCodec.encode((Object)buffer, (Object)stack.getChemical());
                }
            }
        };
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, ChemicalStack> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ChemicalStack>(){

        public ChemicalStack decode(RegistryFriendlyByteBuf buffer) {
            ChemicalStack stack = (ChemicalStack)OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            if (stack.isEmpty()) {
                throw new DecoderException("Empty ChemicalStack not allowed");
            }
            return stack;
        }

        public void encode(RegistryFriendlyByteBuf buffer, ChemicalStack stack) {
            if (stack.isEmpty()) {
                throw new EncoderException("Empty ChemicalStack not allowed");
            }
            OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)stack);
        }
    };
    private final Chemical chemical;
    private long amount;

    public static Codec<ChemicalStack> fixedAmountCodec(int amount) {
        return RecordCodecBuilder.create(instance -> instance.group((App)CHEMICAL_NON_EMPTY_CODEC.fieldOf("id").forGetter(ChemicalStack::getChemical)).apply((Applicative)instance, holder -> new ChemicalStack((Chemical)holder, (long)amount)));
    }

    public ChemicalStack(Holder<Chemical> chemical, long amount) {
        this((Chemical)chemical.value(), amount);
    }

    public ChemicalStack(Chemical chemical, long amount) {
        Objects.requireNonNull(chemical, "Cannot create a ChemicalStack from a null chemical");
        this.chemical = chemical;
        this.amount = amount;
    }

    private ChemicalStack(@Nullable Void unused) {
        this.chemical = null;
    }

    public ChemicalStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new ChemicalStack(this.getChemical(), this.getAmount());
    }

    public ChemicalStack copyWithAmount(long amount) {
        if (this.isEmpty() || amount == 0L) {
            return EMPTY;
        }
        return new ChemicalStack(this.getChemical(), amount);
    }

    public ChemicalStack split(long amount) {
        long i = Math.min(amount, this.getAmount());
        ChemicalStack stack = this.copyWithAmount(i);
        this.shrink(i);
        return stack;
    }

    public ChemicalStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ChemicalStack stack = this.copy();
        this.setAmount(0L);
        return stack;
    }

    public Chemical getChemical() {
        return this.isEmpty() ? MekanismAPI.EMPTY_CHEMICAL : this.chemical;
    }

    public Holder<Chemical> getChemicalHolder() {
        return this.getChemical().getAsHolder();
    }

    public boolean is(TagKey<Chemical> tag) {
        return this.getChemicalHolder().is(tag);
    }

    public boolean is(Chemical chemical) {
        return this.getChemical() == chemical;
    }

    public boolean is(Predicate<Holder<Chemical>> predicate) {
        return predicate.test(this.getChemicalHolder());
    }

    public boolean is(Holder<Chemical> holder) {
        return this.is((Chemical)holder.value());
    }

    public boolean is(HolderSet<Chemical> holderSet) {
        return holderSet.contains(this.getChemicalHolder());
    }

    public Stream<TagKey<Chemical>> getTags() {
        return this.getChemicalHolder().tags();
    }

    public Tag save(HolderLookup.Provider lookupProvider, Tag prefix) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ChemicalStack");
        }
        return (Tag)CODEC.encode((Object)this, (DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)prefix).getOrThrow();
    }

    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot encode empty ChemicalStack");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public Tag saveOptional(HolderLookup.Provider lookupProvider) {
        return this.isEmpty() ? new CompoundTag() : this.save(lookupProvider);
    }

    public ResourceLocation getTypeRegistryName() {
        return this.getChemical().getRegistryName();
    }

    public int getChemicalTint() {
        return this.getChemical().getTint();
    }

    public int getChemicalColorRepresentation() {
        return this.getChemical().getColorRepresentation();
    }

    public boolean isEmpty() {
        return this.chemical == null || this.chemical.isEmptyType() || this.amount <= 0L;
    }

    public long getAmount() {
        return this.isEmpty() ? 0L : this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public void limitSize(long amount) {
        if (!this.isEmpty() && this.getAmount() > amount) {
            this.setAmount(amount);
        }
    }

    public void grow(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.amount - amount);
    }

    @Override
    public boolean has(Class<? extends ChemicalAttribute> type) {
        return this.getChemical().has(type);
    }

    public boolean isRadioactive() {
        return this.getChemical().isRadioactive();
    }

    @Override
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE get(Class<ATTRIBUTE> type) {
        return this.getChemical().get(type);
    }

    @Override
    public Collection<ChemicalAttribute> getAttributes() {
        return this.getChemical().getAttributes();
    }

    @Override
    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return this.getChemical().getAttributeTypes();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.getChemical().hashCode();
        code = 31 * code + Long.hashCode(this.getAmount());
        return code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChemicalStack other = (ChemicalStack)o;
        return this.getChemical() == other.getChemical() && this.getAmount() == other.getAmount();
    }

    public String toString() {
        return "[" + String.valueOf(this.getChemical()) + ", " + this.amount + "]";
    }

    @Override
    public Component getTextComponent() {
        return this.getChemical().getTextComponent();
    }

    @Override
    public String getTranslationKey() {
        return this.getChemical().getTranslationKey();
    }

    public static boolean isSameChemical(ChemicalStack first, ChemicalStack second) {
        return first.is(second.getChemical());
    }

    public static Optional<ChemicalStack> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid chemical: '{}'", error));
    }

    public static ChemicalStack parseOptional(HolderLookup.Provider lookupProvider, CompoundTag tag) {
        return tag.isEmpty() ? EMPTY : ChemicalStack.parse(lookupProvider, (Tag)tag).orElse(EMPTY);
    }
}

