/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalBuilder {
    private final Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> attributeMap = new Object2ObjectOpenHashMap();
    private final ResourceLocation texture;
    private int tint = 0xFFFFFF;
    @Nullable
    private TagKey<Item> oreTag;
    private boolean isGaseous = false;

    protected ChemicalBuilder(ResourceLocation texture) {
        this.texture = texture;
    }

    public ChemicalBuilder with(ChemicalAttribute attribute) {
        this.attributeMap.put(attribute.getClass(), attribute);
        return this;
    }

    public Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> getAttributeMap() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ChemicalBuilder tint(int tint) {
        this.tint = tint;
        return this;
    }

    public int getTint() {
        return this.tint;
    }

    public ChemicalBuilder ore(ResourceLocation oreTagLocation) {
        return this.ore((TagKey<Item>)ItemTags.create((ResourceLocation)Objects.requireNonNull(oreTagLocation)));
    }

    public ChemicalBuilder ore(TagKey<Item> oreTag) {
        this.oreTag = Objects.requireNonNull(oreTag);
        return this;
    }

    @Nullable
    public TagKey<Item> getOreTag() {
        return this.oreTag;
    }

    public ChemicalBuilder gaseous() {
        this.isGaseous = true;
        return this;
    }

    public boolean isGaseous() {
        return this.isGaseous;
    }

    public static ChemicalBuilder builder(ResourceLocation texture) {
        return new ChemicalBuilder(Objects.requireNonNull(texture));
    }

    public static ChemicalBuilder builder() {
        return ChemicalBuilder.builder(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"liquid/liquid"));
    }

    public static ChemicalBuilder cleanSlurry() {
        return ChemicalBuilder.builder(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"slurry/clean"));
    }

    public static ChemicalBuilder dirtySlurry() {
        return ChemicalBuilder.builder(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"slurry/dirty"));
    }

    public static ChemicalBuilder infuseType() {
        return ChemicalBuilder.builder(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"infuse_type/base"));
    }

    public static ChemicalBuilder pigment() {
        return ChemicalBuilder.builder(ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"pigment/base"));
    }
}

