/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.chemical.attribute.IChemicalAttributeContainer;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.text.TextComponentUtil;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class Chemical
implements IChemicalProvider,
IChemicalAttributeContainer<Chemical> {
    public static final Codec<Chemical> CODEC = MekanismAPI.CHEMICAL_REGISTRY.byNameCodec();
    public static final StreamCodec<RegistryFriendlyByteBuf, Chemical> STREAM_CODEC = ByteBufCodecs.registry(MekanismAPI.CHEMICAL_REGISTRY_NAME);
    private final Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> attributeMap;
    private final ResourceLocation iconLocation;
    private final int tint;
    private boolean isRadioactive;
    private boolean hasAttributesWithValidation;
    @Nullable
    private final TagKey<Item> oreTag;
    private final boolean isGaseous;
    @Nullable
    private String translationKey;

    public static Optional<Chemical> parse(HolderLookup.Provider lookupProvider, Tag tag) {
        return CODEC.parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(error -> MekanismAPI.logger.error("Tried to load invalid chemical: '{}'", error));
    }

    public static Chemical parseOptional(HolderLookup.Provider lookupProvider, String tag) {
        if (tag.isEmpty()) {
            return MekanismAPI.EMPTY_CHEMICAL;
        }
        ResourceLocation name = ResourceLocation.tryParse((String)tag);
        return name == null ? MekanismAPI.EMPTY_CHEMICAL : (Chemical)MekanismAPI.CHEMICAL_REGISTRY.get(name);
    }

    public Chemical(ChemicalBuilder builder) {
        this.attributeMap = new HashMap<Class<? extends ChemicalAttribute>, ChemicalAttribute>(builder.getAttributeMap());
        this.iconLocation = builder.getTexture();
        this.tint = builder.getTint();
        this.isRadioactive = this.attributeMap.containsKey(ChemicalAttributes.Radiation.class);
        this.hasAttributesWithValidation = this.isRadioactive || this.attributeMap.values().stream().anyMatch(ChemicalAttribute::needsValidation);
        this.oreTag = builder.getOreTag();
        this.isGaseous = builder.isGaseous();
    }

    public String toString() {
        return "[Chemical: " + String.valueOf(this.getRegistryName()) + "]";
    }

    @Override
    @NotNull
    public Chemical getChemical() {
        return this;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.makeDescriptionId((String)"chemical", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    @Override
    public boolean has(Class<? extends ChemicalAttribute> type) {
        return this.attributeMap.containsKey(type);
    }

    public boolean isRadioactive() {
        return this.isRadioactive;
    }

    public boolean hasAttributesWithValidation() {
        return this.hasAttributesWithValidation;
    }

    @Override
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE get(Class<ATTRIBUTE> type) {
        return (ATTRIBUTE)this.attributeMap.get(type);
    }

    public void addAttribute(ChemicalAttribute attribute) {
        this.attributeMap.put(attribute.getClass(), attribute);
        if (attribute instanceof ChemicalAttributes.Radiation) {
            this.isRadioactive = true;
            this.hasAttributesWithValidation = true;
        } else if (attribute.needsValidation()) {
            this.hasAttributesWithValidation = true;
        }
    }

    @Override
    public Collection<ChemicalAttribute> getAttributes() {
        return this.attributeMap.values();
    }

    @Override
    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return this.attributeMap.keySet();
    }

    @Override
    public Component getTextComponent() {
        return TextComponentUtil.translate(this.getTranslationKey());
    }

    public ResourceLocation getIcon() {
        return this.iconLocation;
    }

    public int getTint() {
        return this.tint;
    }

    public int getColorRepresentation() {
        return this.getTint();
    }

    public boolean is(TagKey<Chemical> tag) {
        return this.getAsHolder().is(tag);
    }

    public Stream<TagKey<Chemical>> getTags() {
        return this.getAsHolder().tags();
    }

    public Holder<Chemical> getAsHolder() {
        return MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)this);
    }

    public boolean isEmptyType() {
        return this == MekanismAPI.EMPTY_CHEMICAL;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)this);
    }

    @Override
    public ChemicalStack getStack(long size) {
        return new ChemicalStack(this, size);
    }

    @Nullable
    public TagKey<Item> getOreTag() {
        return this.oreTag;
    }

    public boolean isGaseous() {
        return this.isGaseous;
    }

    public Tag save(HolderLookup.Provider lookupProvider) {
        if (this.isEmptyType()) {
            throw new IllegalStateException("Cannot encode empty Chemical");
        }
        return (Tag)CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).getOrThrow();
    }

    public Tag saveOptional(HolderLookup.Provider lookupProvider) {
        return this.isEmptyType() ? new CompoundTag() : this.save(lookupProvider);
    }
}

