/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.Objects;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.InterModComms;

public class MekanismIMC {
    public static final String ADD_MODULE_CONTAINER = "add_module_container";
    public static final String ADD_MEKA_TOOL_MODULES = "add_meka_tool_modules";
    public static final String ADD_MEKA_SUIT_HELMET_MODULES = "add_meka_suit_helmet_modules";
    public static final String ADD_MEKA_SUIT_BODYARMOR_MODULES = "add_meka_suit_bodyarmor_modules";
    public static final String ADD_MEKA_SUIT_PANTS_MODULES = "add_meka_suit_pants_modules";
    public static final String ADD_MEKA_SUIT_BOOTS_MODULES = "add_meka_suit_boots_modules";

    private MekanismIMC() {
    }

    public static void addModuleContainer(ItemLike container, String imcMethod) {
        MekanismIMC.addModuleContainer(new ModuleContainerTarget(container, imcMethod));
    }

    public static void addModuleContainer(ModuleContainerTarget moduleContainer) {
        Objects.requireNonNull(moduleContainer, "Module container cannot be null");
        InterModComms.sendTo((String)"mekanism", (String)ADD_MODULE_CONTAINER, () -> moduleContainer);
    }

    public static void addModulesToAll(IModuleDataProvider<?> ... moduleDataProviders) {
        MekanismIMC.addMekaToolModules(moduleDataProviders);
        MekanismIMC.addMekaSuitModules(moduleDataProviders);
    }

    public static void addMekaSuitModules(IModuleDataProvider<?> ... moduleDataProviders) {
        MekanismIMC.addMekaSuitHelmetModules(moduleDataProviders);
        MekanismIMC.addMekaSuitBodyarmorModules(moduleDataProviders);
        MekanismIMC.addMekaSuitPantsModules(moduleDataProviders);
        MekanismIMC.addMekaSuitBootsModules(moduleDataProviders);
    }

    public static void addMekaToolModules(IModuleDataProvider<?> ... moduleDataProviders) {
        MekanismIMC.sendModuleIMC(ADD_MEKA_TOOL_MODULES, moduleDataProviders);
    }

    public static void addMekaSuitHelmetModules(IModuleDataProvider<?> ... moduleDataProviders) {
        MekanismIMC.sendModuleIMC(ADD_MEKA_SUIT_HELMET_MODULES, moduleDataProviders);
    }

    public static void addMekaSuitBodyarmorModules(IModuleDataProvider<?> ... moduleDataProviders) {
        MekanismIMC.sendModuleIMC(ADD_MEKA_SUIT_BODYARMOR_MODULES, moduleDataProviders);
    }

    public static void addMekaSuitPantsModules(IModuleDataProvider<?> ... moduleDataProviders) {
        MekanismIMC.sendModuleIMC(ADD_MEKA_SUIT_PANTS_MODULES, moduleDataProviders);
    }

    public static void addMekaSuitBootsModules(IModuleDataProvider<?> ... moduleDataProviders) {
        MekanismIMC.sendModuleIMC(ADD_MEKA_SUIT_BOOTS_MODULES, moduleDataProviders);
    }

    public static void sendModuleIMC(String imcMethod, IModuleDataProvider<?> ... moduleDataProviders) {
        Objects.requireNonNull(imcMethod, "IMC method cannot be null");
        if (moduleDataProviders == null || moduleDataProviders.length == 0) {
            throw new IllegalArgumentException("No module data providers given.");
        }
        InterModComms.sendTo((String)"mekanism", (String)imcMethod, () -> moduleDataProviders);
    }

    public record ModuleContainerTarget(Item container, String imcMethod) {
        public ModuleContainerTarget(ItemLike container, String imcMethod) {
            this(Objects.requireNonNull(container, "Item cannot be null").asItem(), imcMethod);
        }

        public ModuleContainerTarget {
            Objects.requireNonNull(container, "Item cannot be null");
            Objects.requireNonNull(imcMethod, "IMC method cannot be null");
        }
    }
}

