/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import website.eccentric.tome.ModName;
import website.eccentric.tome.TomeItem;
import website.eccentric.tome.TomeUtils;

@EventBusSubscriber(modid="eccentrictome", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class RenderGuiOverlayHandler {
    public static final LayeredDraw.Layer LAYER = (guiGraphics, deltaTracker) -> {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        HitResult hit = minecraft.hitResult;
        if (!(hit instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        InteractionHand hand = TomeUtils.inHand((Player)minecraft.player);
        if (hand == null) {
            return;
        }
        BlockState state = level.getBlockState(blockHit.getBlockPos());
        if (state.isAir()) {
            return;
        }
        ItemStack tome = player.getItemInHand(hand);
        if (!(tome.getItem() instanceof TomeItem)) {
            return;
        }
        String mod = ModName.from(state);
        Map<String, List<ItemStack>> modsBooks = TomeUtils.getModsBooks(tome).modList();
        if (!modsBooks.containsKey(mod)) {
            return;
        }
        List<ItemStack> books = modsBooks.get(mod);
        if (books.isEmpty()) {
            return;
        }
        ItemStack book = books.get(books.size() - 1);
        Component hoverName = book.getHoverName();
        String convert = I18n.get((String)"eccentrictome.convert", (Object[])new Object[0]);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int x = guiGraphics.guiWidth() / 2 - 17;
        int y = guiGraphics.guiHeight() / 2 + 2;
        guiGraphics.renderItem(book, x, y);
        guiGraphics.drawString(minecraft.font, hoverName, x + 20, y + 4, -1);
        guiGraphics.drawString(minecraft.font, String.valueOf(ChatFormatting.GRAY) + convert, x + 25, y + 14, -1);
    };

    @SubscribeEvent
    public static void registerLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"eccentrictome", (String)"tome_overlay"), LAYER);
    }
}

