/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import website.eccentric.tome.EccentricDataComponents;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.ModListComponent;
import website.eccentric.tome.ModName;
import website.eccentric.tome.TomeItem;

public class TomeUtils {
    public static ItemStack convert(ItemStack tome, ItemStack book) {
        ModListComponent modsBooks = TomeUtils.getModsBooks(tome);
        String mod = ModName.from(book);
        List<ItemStack> books = modsBooks.copy().modList().get(mod);
        ResourceLocation registry = BuiltInRegistries.ITEM.getKey((Object)book.getItem());
        books.removeIf(b -> BuiltInRegistries.ITEM.getKey((Object)b.getItem()).equals((Object)registry));
        EccentricTome.LOGGER.debug("MODSBOOKS: {}", (Object)modsBooks);
        TomeUtils.setModsBooks(book, modsBooks);
        book.set(EccentricDataComponents.IS_TOME, (Object)true);
        TomeUtils.setHoverName(book);
        return book;
    }

    public static ItemStack revert(ItemStack book) {
        ItemStack tome = new ItemStack((ItemLike)EccentricTome.TOME.get());
        TomeUtils.copyMods(book, tome);
        TomeUtils.clear(book);
        return tome;
    }

    public static ItemStack attach(ItemStack tome, ItemStack book) {
        EccentricTome.LOGGER.debug("Attaching");
        String mod = ModName.from(book);
        ModListComponent modsBooks = TomeUtils.getModsBooks(tome);
        Map<String, List<ItemStack>> modListCopy = modsBooks.copy().modList();
        List books = modListCopy.getOrDefault(mod, new ArrayList());
        ItemStack itemStack = book.copyWithCount(1);
        if (books.contains(itemStack)) {
            return ItemStack.EMPTY;
        }
        for (ItemStack book1 : books) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)book1, (ItemStack)book)) continue;
            return ItemStack.EMPTY;
        }
        books.add(itemStack);
        modListCopy.put(mod, books);
        TomeUtils.setModsBooks(tome, new ModListComponent(modListCopy));
        return tome;
    }

    public static ModListComponent remove(ItemStack tome, ItemStack bookToRemove) {
        ModListComponent modListComponent = TomeUtils.getModsBooks(tome).copy();
        Map<String, List<ItemStack>> modList = modListComponent.modList();
        String modId = bookToRemove.getItem().getCreatorModId(bookToRemove);
        List<ItemStack> itemStacks = modList.get(modId);
        itemStacks.remove(bookToRemove);
        if (itemStacks.isEmpty()) {
            modList.remove(modId);
        }
        return modListComponent;
    }

    public static ModListComponent getModsBooks(ItemStack stack) {
        return (ModListComponent)stack.get(EccentricDataComponents.MOD_LIST);
    }

    public static void setModsBooks(ItemStack stack, ModListComponent modsBooks) {
        stack.set(EccentricDataComponents.MOD_LIST, (Object)modsBooks);
    }

    public static boolean isTome(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (stack.getItem() instanceof TomeItem) {
            return true;
        }
        return Boolean.TRUE.equals(stack.get(EccentricDataComponents.IS_TOME));
    }

    @Nullable
    public static InteractionHand inHand(Player player) {
        InteractionHand hand = InteractionHand.MAIN_HAND;
        ItemStack stack = player.getItemInHand(hand);
        if (TomeUtils.isTome(stack)) {
            return hand;
        }
        hand = InteractionHand.OFF_HAND;
        stack = player.getItemInHand(hand);
        if (TomeUtils.isTome(stack)) {
            return hand;
        }
        return null;
    }

    private static void copyMods(ItemStack source, ItemStack target) {
        target.set(EccentricDataComponents.MOD_LIST, (Object)((ModListComponent)source.get(EccentricDataComponents.MOD_LIST)).copy());
    }

    private static void clear(ItemStack stack) {
        stack.remove(EccentricDataComponents.MOD_LIST);
        stack.remove(EccentricDataComponents.IS_TOME);
        stack.remove(EccentricDataComponents.VERSION);
        stack.set(DataComponents.CUSTOM_NAME, (Object)((Component)stack.get(DataComponents.ITEM_NAME)));
    }

    private static void setHoverName(ItemStack book) {
        MutableComponent name = book.getHoverName().copy().withStyle(ChatFormatting.GREEN);
        book.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"eccentrictome.name", (Object[])new Object[]{name}));
    }
}

