/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import website.eccentric.tome.EccentricDataComponents;
import website.eccentric.tome.ModListComponent;
import website.eccentric.tome.ModName;
import website.eccentric.tome.TomeClientUtils;
import website.eccentric.tome.TomeUtils;
import website.eccentric.tome.network.ConvertPayload;

public class TomeItem
extends Item {
    public TomeItem() {
        super(new Item.Properties().stacksTo(1).component(EccentricDataComponents.MOD_LIST, (Object)ModListComponent.EMPTY).component(EccentricDataComponents.IS_TOME, (Object)false).component(EccentricDataComponents.VERSION, (Object)0));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        InteractionHand hand = context.getHand();
        BlockPos position = context.getClickedPos();
        ItemStack tome = context.getItemInHand();
        String mod = ModName.from(context.getLevel().getBlockState(position));
        Map<String, List<ItemStack>> modsBooks = TomeUtils.getModsBooks(tome).modList();
        if (!player.isShiftKeyDown() || !modsBooks.containsKey(mod)) {
            return InteractionResult.PASS;
        }
        List<ItemStack> books = modsBooks.get(mod);
        if (!books.isEmpty() && context.getLevel().isClientSide) {
            ItemStack book = books.getLast();
            PacketDistributor.sendToServer((CustomPacketPayload)new ConvertPayload(book), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack tome = player.getItemInHand(hand);
        if (level.isClientSide) {
            TomeClientUtils.openTome(tome);
        }
        return InteractionResultHolder.sidedSuccess((Object)tome, (boolean)level.isClientSide);
    }

    public void appendHoverText(ItemStack tome, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        Map<String, List<ItemStack>> modsBooks = TomeUtils.getModsBooks(tome).modList();
        for (String mod : modsBooks.keySet()) {
            tooltip.add((Component)Component.literal((String)ModName.name(mod)));
            List<ItemStack> books = modsBooks.get(mod);
            for (ItemStack book : books) {
                if (book.is(Items.AIR)) continue;
                String name = book.getHoverName().getString();
                tooltip.add((Component)Component.literal((String)("  " + String.valueOf(ChatFormatting.GRAY) + name)));
            }
        }
    }
}

