/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import website.eccentric.tome.AttachmentRecipe;
import website.eccentric.tome.EccentricConfig;
import website.eccentric.tome.EccentricDataComponents;
import website.eccentric.tome.ModListComponent;
import website.eccentric.tome.TomeItem;
import website.eccentric.tome.TomeUtils;
import website.eccentric.tome.network.RevertPayload;

@Mod(value="eccentrictome")
public class EccentricTome {
    public static final String ID = "eccentrictome";
    public static final Logger LOGGER = LogManager.getLogger((String)"eccentrictome");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"eccentrictome");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"eccentrictome");
    public static final Supplier<RecipeSerializer<?>> ATTACHMENT = RECIPES.register("attachment", () -> new SimpleCraftingRecipeSerializer(AttachmentRecipe::new));
    public static final DeferredItem<Item> TOME = ITEMS.register("tome", TomeItem::new);

    public EccentricTome(IEventBus modEvent, ModContainer container) {
        ITEMS.register(modEvent);
        RECIPES.register(modEvent);
        EccentricDataComponents.COMPONENTS.register(modEvent);
        modEvent.addListener(this::onClientSetup);
        modEvent.addListener(this::onModConfig);
        modEvent.addListener(this::onBuildCreativeModeTabContents);
        modEvent.addListener(this::modifyDefaultComponents);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EccentricConfig.SPEC);
        IEventBus minecraftEvent = NeoForge.EVENT_BUS;
        minecraftEvent.addListener(EventPriority.LOW, this::onItemDropped);
        minecraftEvent.addListener(this::onRightClickTomeItem);
        minecraftEvent.addListener(this::onRightClickTomeOnBlock);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        IEventBus minecraftEvent = NeoForge.EVENT_BUS;
        minecraftEvent.addListener(this::onLeftClickEmpty);
    }

    private void onModConfig(ModConfigEvent event) {
        EccentricConfig.ALIAS_MAP.clear();
        for (String alias : (List)EccentricConfig.ALIASES.get()) {
            String[] tokens = alias.split("=");
            EccentricConfig.ALIAS_MAP.put(tokens[0], tokens[1]);
        }
    }

    private void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (TomeUtils.isTome(stack) && !(stack.getItem() instanceof TomeItem)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RevertPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void onRightClickTomeItem(PlayerInteractEvent.RightClickItem event) {
        event.setCanceled(EccentricTome.onRightClickTome((PlayerInteractEvent)event));
    }

    private void onRightClickTomeOnBlock(PlayerInteractEvent.RightClickBlock event) {
        event.setCanceled(EccentricTome.onRightClickTome((PlayerInteractEvent)event));
    }

    private static boolean onRightClickTome(PlayerInteractEvent event) {
        ItemStack stack = event.getItemStack();
        if (!(stack.getItem() instanceof TomeItem) && ((Boolean)stack.getOrDefault(EccentricDataComponents.IS_TOME, (Object)false)).booleanValue()) {
            ItemStack prevStack = stack.copy();
            Player player = event.getEntity();
            InteractionHand hand = event.getHand();
            stack.use(event.getLevel(), player, hand);
            if (player.getMainHandItem().isEmpty()) {
                ModListComponent component = TomeUtils.remove(prevStack, stack);
                ItemStack newStack = TOME.toStack();
                newStack.set(EccentricDataComponents.MOD_LIST, (Object)component);
                player.setItemInHand(hand, newStack);
            }
            return true;
        }
        return false;
    }

    private void onItemDropped(ItemTossEvent event) {
        if (!event.getPlayer().isShiftKeyDown()) {
            return;
        }
        ItemEntity entity = event.getEntity();
        ItemStack stack = entity.getItem();
        if (TomeUtils.isTome(stack) && !(stack.getItem() instanceof TomeItem)) {
            ItemStack detatchment = TomeUtils.revert(stack);
            Level level = entity.getCommandSenderWorld();
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), detatchment));
            }
            entity.setItem(stack);
        }
    }

    private void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
            event.accept(TOME);
        }
    }

    private void modifyDefaultComponents(ModifyDefaultComponentsEvent event) {
        event.modifyMatching(item -> {
            ResourceLocation itemKey = BuiltInRegistries.ITEM.getKey(item);
            String namespace = itemKey.getNamespace();
            return namespace.equals("patchouli") || namespace.equals("modonomicon") || ((List)EccentricConfig.ITEMS.get()).contains(item.toString());
        }, builder -> builder.set(EccentricDataComponents.MOD_LIST.get(), (Object)ModListComponent.EMPTY).set(EccentricDataComponents.IS_TOME.get(), (Object)false).set(EccentricDataComponents.VERSION.get(), (Object)0));
    }
}

