/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils;

import com.heaser.pipeconnector.config.PipeConnectorConfig;
import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.constants.ComponentDataTags;
import com.heaser.pipeconnector.utils.NodeParameter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class TagUtils {
    public static List<NodeParameter> getNodesFromStack(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        ArrayList<NodeParameter> nodes = new ArrayList<NodeParameter>();
        if (tag.contains(ComponentDataTags.kPipeConnectorNodes, 9)) {
            ListTag nodeTags = tag.getList(ComponentDataTags.kPipeConnectorNodes, 10);
            for (int index = 0; index < nodeTags.size(); ++index) {
                CompoundTag nodeTag = nodeTags.getCompound(index);
                nodes.add(new NodeParameter(nodeTag));
            }
        }
        return nodes;
    }

    public static void setNodesToStack(ItemStack stack, List<NodeParameter> nodes) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
            ListTag list = new ListTag();
            for (NodeParameter node : nodes) {
                CompoundTag nodeTag = TagUtils.convertNodeToTag(node);
                list.addTag(list.size(), (Tag)nodeTag);
            }
            tag.put(ComponentDataTags.kPipeConnectorNodes, (Tag)list);
        });
    }

    public static CompoundTag convertNodeToTag(NodeParameter node) {
        CompoundTag nodeTag = new CompoundTag();
        nodeTag.putInt(ComponentDataTags.kPipeConnectorNodePositionX, node.position.getX());
        nodeTag.putInt(ComponentDataTags.kPipeConnectorNodePositionY, node.position.getY());
        nodeTag.putInt(ComponentDataTags.kPipeConnectorNodePositionZ, node.position.getZ());
        nodeTag.putByte(ComponentDataTags.kPipeConnectorNodeDirection, (byte)node.direction.get3DDataValue());
        return nodeTag;
    }

    public static int getDepthFromStack(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(ComponentDataTags.kPipeConnectorDepth, 3)) {
            return tag.getInt(ComponentDataTags.kPipeConnectorDepth);
        }
        return 0;
    }

    public static void setDepthToStack(ItemStack stack, int depth) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> {
            int finalDepth = depth < 0 ? (Integer)PipeConnectorConfig.MAX_DEPTH.get() : (depth > (Integer)PipeConnectorConfig.MAX_DEPTH.get() ? 0 : depth);
            tag.putInt(ComponentDataTags.kPipeConnectorDepth, finalDepth);
        });
    }

    public static String getDimension(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(ComponentDataTags.kPipeConnectorDimensionName)) {
            return tag.getString(ComponentDataTags.kPipeConnectorDimensionName);
        }
        return "";
    }

    public static void setDimension(ItemStack stack, String dimensionName) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putString(ComponentDataTags.kPipeConnectorDimensionName, dimensionName));
    }

    public static BridgeType getBridgeType(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(ComponentDataTags.kPipeConnectorBridgeType, 8)) {
            return BridgeType.valueOf(tag.getString(ComponentDataTags.kPipeConnectorBridgeType));
        }
        return BridgeType.DEFAULT;
    }

    public static void setBridgeType(ItemStack stack, BridgeType bridgeType) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putString(ComponentDataTags.kPipeConnectorBridgeType, bridgeType.toString()));
    }

    public static boolean getUtilizeExistingPipes(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(ComponentDataTags.kPipeConnectorUtilizeExistingPipes, 1)) {
            return tag.getBoolean(ComponentDataTags.kPipeConnectorUtilizeExistingPipes);
        }
        return false;
    }

    public static void setUtilizeExistingPipes(ItemStack stack, boolean utilizeExistingPipes) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putBoolean(ComponentDataTags.kPipeConnectorUtilizeExistingPipes, utilizeExistingPipes));
    }

    public static boolean getPreventInventoryBlockBreaking(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(ComponentDataTags.kPipeConnectorInventoryGuard, 1)) {
            return tag.getBoolean(ComponentDataTags.kPipeConnectorInventoryGuard);
        }
        return true;
    }

    public static void setInventoryGuard(ItemStack stack, boolean shouldBreakInventoryBlocks) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putBoolean(ComponentDataTags.kPipeConnectorInventoryGuard, shouldBreakInventoryBlocks));
    }

    public static void resetPositionAndDirectionTags(ItemStack stack, Player player, boolean shouldShowMessage) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.remove(ComponentDataTags.kPipeConnectorNodes));
        if (shouldShowMessage) {
            player.displayClientMessage((Component)Component.translatable((String)"item.pipe_connector.message.resettingPositions"), true);
        }
    }

    public static void setCustomModelData(ItemStack stack, boolean useCustomModelData) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (useCustomModelData) {
            tag.putInt(ComponentDataTags.kPipeConnectorCustomModelData, 1);
        } else {
            tag.putInt(ComponentDataTags.kPipeConnectorCustomModelData, 0);
        }
    }

    public static void setCustomModelData(CompoundTag tag, boolean useCustomModelData) {
        if (useCustomModelData) {
            tag.putInt(ComponentDataTags.kPipeConnectorCustomModelData, 1);
        } else {
            tag.putInt(ComponentDataTags.kPipeConnectorCustomModelData, 0);
        }
    }

    public static int getCustomModelData(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag.contains(ComponentDataTags.kPipeConnectorCustomModelData, 3)) {
            return tag.getInt(ComponentDataTags.kPipeConnectorCustomModelData);
        }
        return 0;
    }
}

