/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.utils;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ChunkRangeIterator
implements Iterator<BlockPos> {
    private final Level level;
    private final int minX;
    private final int minZ;
    private final int maxX;
    private final int maxZ;
    private int currentX;
    private int currentY;
    private int currentZ;
    private final boolean reverseY;

    public ChunkRangeIterator(Level level, ChunkPos startPos, int size) {
        this(level, startPos, size, false);
    }

    public ChunkRangeIterator(Level level, ChunkPos startPos, int size, boolean reverseY) {
        this.level = level;
        int rangeSize = Math.max(0, size / 2);
        this.minX = startPos.x - rangeSize << 4;
        this.minZ = startPos.z - rangeSize << 4;
        this.maxX = (startPos.x + rangeSize << 4) + 16;
        this.maxZ = (startPos.z + rangeSize << 4) + 16;
        this.currentX = this.minX;
        this.currentZ = this.minZ;
        this.reverseY = reverseY;
        this.currentY = reverseY ? level.getMaxBuildHeight() : level.getMinBuildHeight();
    }

    @Override
    public boolean hasNext() {
        return (this.reverseY ? this.currentY > this.level.getMinBuildHeight() : this.currentY < this.level.getMaxBuildHeight()) && this.currentZ < this.maxZ && this.currentX < this.maxX;
    }

    @Override
    public BlockPos next() {
        BlockPos pos = new BlockPos(this.currentX, this.currentY, this.currentZ);
        ++this.currentX;
        if (this.currentX >= this.maxX) {
            this.currentX = this.minX;
            ++this.currentZ;
            if (this.currentZ >= this.maxZ) {
                this.currentZ = this.minZ;
                this.currentY = this.reverseY ? --this.currentY : ++this.currentY;
            }
        }
        return pos;
    }
}

