/*
 * Decompiled with CFR 0.152.
 */
package nolijium.mixinextras.sugar.impl.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nolijium.mixinextras.lib.apache.commons.tuple.Pair;
import nolijium.mixinextras.service.MixinExtrasService;
import nolijium.mixinextras.sugar.Local;
import nolijium.mixinextras.sugar.impl.SugarParameter;
import nolijium.mixinextras.sugar.impl.handlers.HandlerInfo;
import nolijium.mixinextras.sugar.impl.handlers.LocalHandlerTransformer;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public abstract class HandlerTransformer {
    private static final Map MAP = new HashMap();
    protected final IMixinInfo mixin;
    protected final SugarParameter parameter;

    HandlerTransformer(IMixinInfo iMixinInfo, SugarParameter sugarParameter) {
        this.mixin = iMixinInfo;
        this.parameter = sugarParameter;
    }

    public abstract boolean isRequired(MethodNode var1);

    public abstract void transform(HandlerInfo var1);

    public static HandlerTransformer create(IMixinInfo iMixinInfo, SugarParameter sugarParameter) {
        try {
            Class clazz = (Class)MAP.get(sugarParameter.sugar.desc);
            if (clazz == null) {
                return null;
            }
            return (HandlerTransformer)clazz.getDeclaredConstructor(IMixinInfo.class, SugarParameter.class).newInstance(iMixinInfo, sugarParameter);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    static {
        for (Pair pair : Arrays.asList(Pair.of(Local.class, LocalHandlerTransformer.class))) {
            for (String string : MixinExtrasService.getInstance().getAllClassNames(((Class)pair.getLeft()).getName())) {
                MAP.put("L" + string.replace('.', '/') + ';', (Class)pair.getRight());
            }
        }
    }
}

