/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.network;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.level.VolumeLevelAttachment;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.serialization.BinarySerializer;
import tv.soaryn.xycraft.core.utils.serialization.Serializer;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.volumes.IlluminationVolume;
import tv.soaryn.xycraft.machines.utils.mixins.ILevelLightEngineMix;

public record CBLightVolumePacket(BlockPos pos, VolumeAction added, boolean relight) implements Packet.ClientBound
{
    public static final BinarySerializer<CBLightVolumePacket> SerDes = BinarySerializer.ofType(CBLightVolumePacket::new, CBLightVolumePacket::pos, (BinarySerializer)Serializer.BLOCK_POS, CBLightVolumePacket::added, (BinarySerializer)BinarySerializer.ofEnum(VolumeAction.class), CBLightVolumePacket::relight, (BinarySerializer)Serializer.BOOLEAN);

    public static void broadcast(@NotNull Level level, @NotNull BlockPos pos, VolumeAction added, boolean relight) {
        XyMachines.Network.broadcast(level, pos, (Packet.ClientBound)new CBLightVolumePacket(pos, added, relight));
    }

    public void handle(Packet.ClientBound.Context context) {
        context.enqueueMainThread(() -> {
            Level level = context.player().level();
            FastVolumeLookup lookup = FastVolumeLookup.of((Level)level, IlluminationVolume.class);
            ILevelLightEngineMix mix = (ILevelLightEngineMix)level.getLightEngine();
            switch (this.added.ordinal()) {
                case 0: {
                    VolumeLevelAttachment.add((Level)level, (BlockPos)this.pos, MachinesAttachments.IlluminationVolumeData);
                    if (!this.relight()) break;
                    lookup.getAllBoxes(this.pos).forEach(mix::xycraft$checkVolume);
                    break;
                }
                case 1: {
                    Stream positions = lookup.getAllBoxes(this.pos);
                    if (this.relight()) {
                        positions.forEach(mix::xycraft$checkVolume);
                    }
                    VolumeLevelAttachment.remove((Level)level, (BlockPos)this.pos, MachinesAttachments.IlluminationVolumeData);
                    break;
                }
                case 2: {
                    lookup.getAllBoxes(this.pos).forEach(mix::xycraft$checkVolume);
                }
            }
        });
    }

    public static enum VolumeAction {
        Add,
        Remove,
        Update;

    }
}

