/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems.multiblocks;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.core.content.attachments.accessors.CapAccess;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.systems.BlockTickSystemLevelAttachment;
import tv.soaryn.xycraft.core.content.systems.ServerBlockTickSystem;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

public class EnergyPipeExtractionSystem
extends ServerBlockTickSystem<BlockTickSystemLevelAttachment> {
    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        return state.is(MachinesContent.Block.PipeEnergy.block());
    }

    public void clean(ServerLevel level, BlockPos.MutableBlockPos pos) {
        XyBlock.clean((Block)MachinesContent.Block.PipeEnergy.block(), (ServerLevel)level, (BlockPos.MutableBlockPos)pos);
        XyMachines.Logger.error("Energy Extraction Pipe at block position {} was moved without calling onRemove. Take note of how it may have been moved and please report this on https://github.com/Soaryn/XyCraftTracker/issues", (Object)pos.toShortString());
    }

    protected void tickBatchBlocks(ServerLevel level, BlockTickSystemLevelAttachment tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlockEntity blockEntity = level.getBlockEntity((BlockPos)pos);
        if (blockEntity == null) {
            return;
        }
        IPipeConnection extractor = (IPipeConnection)level.getCapability(IPipeConnection.BLOCK, (BlockPos)pos, null);
        if (extractor == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            int simulatedFill;
            IEnergyStorage pipeCap;
            int simulatedDrain;
            IEnergyStorage otherCap;
            PipeConnectionType logic;
            if (extractor.isClosed(dir) || (logic = extractor.getLogic(dir)) != PipeConnectionType.Extract || (otherCap = CapAccess.energy((BlockEntity)blockEntity, (Direction)dir)) == null || (simulatedDrain = otherCap.extractEnergy(1000000000, true)) <= 0 || (pipeCap = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, (BlockPos)pos, (Object)dir)) == null || (simulatedFill = pipeCap.receiveEnergy(simulatedDrain, true)) == 0) continue;
            int actualDrain = otherCap.extractEnergy(simulatedFill, false);
            pipeCap.receiveEnergy(actualDrain, false);
        }
    }

    @NotNull
    protected Supplier<AttachmentType<BlockTickSystemLevelAttachment>> getAttachmentType() {
        return MachinesAttachments.EnergyPipeExtractionSystemData;
    }
}

