/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems.multiblocks;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.InventoryAttachment;
import tv.soaryn.xycraft.machines.content.attachments.level.ProducerTickSystemLevelAttachment;
import tv.soaryn.xycraft.machines.content.recipes.producers.blender.BlenderRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.machines.content.systems.multiblocks.ProducerTickSystem;

public class BlenderTickSystem
extends ProducerTickSystem<BlenderRecipe, BlenderRecipe.Input> {
    public static final Codec<ProducerTickSystemLevelAttachment<BlenderRecipe, BlenderRecipe.Input>> CODEC = RecordCodecBuilder.create(builder -> ProducerTickSystemLevelAttachment.producerGroup(builder).apply((Applicative)builder, (chunkMap, frequency, enabled) -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)chunkMap, (long)frequency, (boolean)enabled, (RecipeType)MachinesRecipeTypes.Blender.type().get())));
    public static final AttachmentType.Builder<ProducerTickSystemLevelAttachment<BlenderRecipe, BlenderRecipe.Input>> Builder = AttachmentType.builder(() -> new ProducerTickSystemLevelAttachment((Long2ObjectOpenHashMap<LongArraySet>)new Long2ObjectOpenHashMap(), 10L, true, (RecipeType)MachinesRecipeTypes.Blender.type().get())).serialize(CODEC);

    public boolean isValidState(ServerLevel level, BlockState state, BlockPos pos) {
        throw new NotImplementedException();
    }

    protected void tickBlocks(ServerLevel level, ProducerTickSystemLevelAttachment<BlenderRecipe, BlenderRecipe.Input> tickData, BlockPos.MutableBlockPos pos, BlockState state, long currentStep) {
        BlenderRecipe recipe = this.getRecipe(level, tickData, (BlockPos)pos, state, currentStep);
        if (recipe == null) {
            return;
        }
        InventoryAttachment data = (InventoryAttachment)Objects.requireNonNull(level.getBlockEntity((BlockPos)pos)).getData(MachinesAttachments.SoarynBoxData);
    }

    @Override
    public BlenderRecipe.Input getInput(ServerLevel level, ProducerTickSystemLevelAttachment<BlenderRecipe, BlenderRecipe.Input> tickData, BlockPos pos, BlockState state, long currentStep) {
        final InventoryAttachment data = (InventoryAttachment)Objects.requireNonNull(level.getBlockEntity(pos)).getData(MachinesAttachments.SoarynBoxData);
        return new BlenderRecipe.Input(){

            @Override
            public ItemStack getInputItem(int index) {
                return data.getInventory().get(index);
            }

            @Override
            public FluidStack getInputFluid(int index) {
                return FluidStack.EMPTY;
            }
        };
    }

    @Override
    public long getTimeRequired(BlenderRecipe recipe) {
        return recipe.ticks();
    }

    @NotNull
    protected Supplier<AttachmentType<ProducerTickSystemLevelAttachment<BlenderRecipe, BlenderRecipe.Input>>> getAttachmentType() {
        return MachinesAttachments.BlenderSystemData;
    }
}

