/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.systems;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.core.content.attachments.accessors.Ticks;
import tv.soaryn.xycraft.core.content.systems.ISystemData;
import tv.soaryn.xycraft.core.content.systems.LevelSystemAttachment;
import tv.soaryn.xycraft.core.content.systems.LevelSystemBase;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.xynergy.XynergyNetGraphLevelAttachment;

public class XynergyGraphTickSystem
extends LevelSystemBase<LevelSystemAttachment> {
    public void preTick(LevelTickEvent event, LevelSystemAttachment data) {
        ServerLevel serverLevel;
        super.preTick(event, (ISystemData)data);
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel) || !(serverLevel = (ServerLevel)level).tickRateManager().runsNormally()) {
            return;
        }
        if (Ticks.of((IAttachmentHolder)serverLevel) % data.frequency() != 0L) {
            return;
        }
        ProfilerFiller profiler = serverLevel.getProfiler();
        XynergyNetGraphLevelAttachment net = (XynergyNetGraphLevelAttachment)serverLevel.getData(MachinesAttachments.XynergyNetData);
        profiler.push("xycraft:xynergy.tick");
        profiler.push(serverLevel.dimension().location().getPath());
        switch (net.state) {
            case Revalidate: {
                profiler.push("revalidate");
                net.revalidateValues(serverLevel);
                profiler.pop();
                break;
            }
            case Clean: {
                profiler.push("clean");
                net.cleanValues();
                profiler.pop();
            }
        }
        net.state = net.state.next();
        profiler.pop();
        profiler.pop();
    }

    @NotNull
    protected Supplier<AttachmentType<LevelSystemAttachment>> getAttachmentType() {
        return MachinesAttachments.XynergySystemData;
    }
}

