/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.multiblock.pipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultEdge;
import tv.soaryn.xycraft.api.content.pipes.EdgeData;
import tv.soaryn.xycraft.api.content.pipes.PipeGraph;
import tv.soaryn.xycraft.api.content.pipes.PipeGroup;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.api.content.pipes.PipeRoute;
import tv.soaryn.xycraft.api.content.pipes.examples.BufferedPipeGraph;
import tv.soaryn.xycraft.core.network.Packet;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;
import tv.soaryn.xycraft.machines.XyMachines;
import tv.soaryn.xycraft.machines.network.CBFluidPipeGraphUpdatePacket;
import tv.soaryn.xycraft.machines.network.CBPipeGraphFormPacket;
import tv.soaryn.xycraft.machines.network.CBPipeGraphRemovePacket;
import tv.soaryn.xycraft.machines.network.CBPipeGraphRemovePipePacket;

public final class FluidPipeGraph
extends BufferedPipeGraph<IFluidHandler, FluidPipeGraph> {
    public static final Codec<FluidPipeGraph> CODEC = RecordCodecBuilder.create(builder -> PipeGraph.pipeGroup((RecordCodecBuilder.Instance)builder, (BlockCapability)Capabilities.FluidHandler.BLOCK).and(builder.group((App)FluidPipeGraph.bufferCodecRecord(), (App)CodecUtils.Codecs.FLUID_STACK_OPTIONAL.fieldOf("filter").forGetter(data -> data.Filter))).apply((Applicative)builder, FluidPipeGraph::new));
    public FluidStack Filter = FluidStack.EMPTY;
    private FluidStack _prevFilter = FluidStack.EMPTY;
    public long FilterDecayTick = 10L;
    public static final AttachmentType.Builder<PipeNetwork<FluidPipeGraph, IFluidHandler>> NetworkBuilder = PipeNetwork.builder(CODEC, FluidPipeGraph::new);
    long prevSum = 0L;
    private final ArrayList<Object2ObjectMap.Entry<IFluidHandler, ObjectArraySet<PipeGroup<?>>>> _distributionList = new ArrayList();
    private boolean _hasFluidStored = false;

    public FluidPipeGraph(UUID uuid) {
        super(uuid, new PipeRoute(Capabilities.FluidHandler.BLOCK));
    }

    public FluidPipeGraph(UUID uuid, PipeRoute<IFluidHandler> pipeRoute, Set<PipeGroup<IFluidHandler>> serializedBuffers, FluidStack filter) {
        super(uuid, pipeRoute, serializedBuffers);
        this.Filter = filter.copyWithAmount(Integer.MAX_VALUE);
    }

    public long getDemand(IFluidHandler handler) {
        return handler.fill(this.Filter, IFluidHandler.FluidAction.SIMULATE);
    }

    protected long getMinimumBuffer() {
        return 1000L;
    }

    public void postTick(ServerLevel level) {
        if (!FluidStack.isSameFluidSameComponents((FluidStack)this.Filter, (FluidStack)this._prevFilter)) {
            // empty if block
        }
        this._prevFilter = this.Filter;
        if (this.Filter.getFluid() == Fluids.EMPTY) {
            return;
        }
        super.postTick(level);
        if (this._hasFluidStored) {
            this.FilterDecayTick = 10L;
        }
        if (--this.FilterDecayTick <= 0L) {
            this.Filter = FluidStack.EMPTY;
            this.FilterDecayTick = 10L;
            XyMachines.Network.broadcast((Level)level, (Packet.ClientBound)new CBFluidPipeGraphUpdatePacket(this.id(), FluidStack.EMPTY, 0L));
        } else {
            long sum = 0L;
            for (PipeGroup value : this.getAllBuffers()) {
                sum += value.Stored;
            }
            if (this.prevSum != sum) {
                XyMachines.Network.broadcast((Level)level, (Packet.ClientBound)new CBFluidPipeGraphUpdatePacket(this.id(), this.Filter, sum));
            }
            this.prevSum = sum;
        }
    }

    public void distribute(Object2ObjectOpenHashMap<IFluidHandler, ObjectArraySet<PipeGroup<?>>> receiverGroup) {
        if (receiverGroup.isEmpty()) {
            this._hasFluidStored = this.BufferMap.values().stream().anyMatch(g -> g.Stored > 0L);
            return;
        }
        this._hasFluidStored = false;
        this._distributionList.addAll((Collection<Object2ObjectMap.Entry<IFluidHandler, ObjectArraySet<PipeGroup<?>>>>)receiverGroup.object2ObjectEntrySet());
        Collections.shuffle(this._distributionList);
        for (Object2ObjectMap.Entry<IFluidHandler, ObjectArraySet<PipeGroup<?>>> entry : this._distributionList) {
            IFluidHandler cap = (IFluidHandler)entry.getKey();
            ObjectArraySet buffers = (ObjectArraySet)entry.getValue();
            long sum = 0L;
            for (PipeGroup pipeGroup : buffers) {
                long pipeGroupStored = pipeGroup.getStored();
                sum += pipeGroupStored;
            }
            int stored = MathUtils.toInt((long)sum);
            if (stored > 0) {
                this._hasFluidStored = true;
            }
            int amountAbsorbed = cap.fill(this.Filter.copyWithAmount(stored), IFluidHandler.FluidAction.EXECUTE);
            for (PipeGroup buffer : buffers) {
                long handled = Math.min(buffer.Stored, (long)amountAbsorbed);
                buffer.Stored -= handled;
                amountAbsorbed -= MathUtils.toInt((long)handled);
            }
        }
        this._distributionList.clear();
    }

    public void copyDataFrom(FluidPipeGraph otherGraph) {
        super.copyDataFrom((BufferedPipeGraph)otherGraph);
        if (this.Filter.isEmpty()) {
            this.Filter = otherGraph.Filter.copy();
        }
    }

    public void onGraphForm(ServerLevel level, UUID uuid, LongArraySet nodes, Set<EdgeData> edges) {
        XyMachines.Network.broadcast((Level)level, (Packet.ClientBound)new CBPipeGraphFormPacket(uuid, nodes, edges));
        long sum = 0L;
        for (PipeGroup value : this.getAllBuffers()) {
            sum = MathUtils.longSumUp((long)sum, (long)value.Stored);
        }
        XyMachines.Network.broadcast((Level)level, (Packet.ClientBound)new CBFluidPipeGraphUpdatePacket(uuid, sum == 0L ? FluidStack.EMPTY : this.Filter, sum));
    }

    public void onGraphRemove(ServerLevel level, UUID uuids) {
        XyMachines.Network.broadcast((Level)level, (Packet.ClientBound)new CBPipeGraphRemovePacket(uuids));
    }

    public void onPipeRemoved(ServerLevel level, long posId) {
        XyMachines.Network.broadcast((Level)level, (Packet.ClientBound)new CBPipeGraphRemovePipePacket(posId));
        PipeGroup buffer = (PipeGroup)this.BufferMap.get(this.PosToPipeGroup.get(posId));
        if (buffer == null || buffer.Group == null) {
            return;
        }
        Set edges = buffer.Group.outgoingEdgesOf((Object)posId);
        if (!edges.isEmpty()) {
            buffer.Anchor = ((EdgeData)edges.iterator().next()).dst();
            return;
        }
        Optional outgoing = this.CondensedGraph.outgoingEdgesOf((Object)buffer.Group).stream().findAny();
        if (outgoing.isEmpty()) {
            return;
        }
        Graph otherGraph = (Graph)this.CondensedGraph.getEdgeTarget((Object)((DefaultEdge)outgoing.get()));
        PipeGroup otherBuffer = (PipeGroup)this.BufferMap.get((Object)otherGraph);
        if (otherBuffer == null) {
            return;
        }
        long handledAmount = Math.min(otherBuffer.AcceptanceBuffer - buffer.Stored, buffer.Stored);
        if (handledAmount > 0L) {
            otherBuffer.Stored += handledAmount;
        }
    }

    public boolean canMerge(FluidPipeGraph otherGraph) {
        return this.Filter.isEmpty() || otherGraph == null || otherGraph.Filter.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)otherGraph.Filter, (FluidStack)this.Filter);
    }
}

