/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items.modular.proto.modules.gauntlet;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModule;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModuleContainer;
import tv.soaryn.xycraft.api.content.capabilities.modular.ModuleType;
import tv.soaryn.xycraft.core.content.XyCraftTags;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.IToolModule;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.gauntlet.logic.BlockSearchLogic;
import tv.soaryn.xycraft.machines.content.items.modular.proto.modules.gauntlet.logic.VeinSearch;
import tv.soaryn.xycraft.machines.content.registries.MachinesDataComponents;

public record MineLogicModule(BlockSearchLogic logic) implements IToolModule
{
    private static final BlockSearchLogic area = (level, origin, direction, amount) -> {
        float originBreakSpeed = level.getBlockState(origin).getDestroySpeed((BlockGetter)level, origin);
        return MineLogicModule.getRadiusBlocks(origin, direction, 1).filter(pos -> {
            BlockState blockstate = level.getBlockState(pos);
            if (blockstate.isAir()) {
                return false;
            }
            if (!blockstate.getFluidState().isEmpty()) {
                return false;
            }
            float targetBlockBreakSpeed = blockstate.getDestroySpeed((BlockGetter)level, pos);
            if (originBreakSpeed == 0.0f && targetBlockBreakSpeed > 0.0f) {
                return false;
            }
            return !(targetBlockBreakSpeed < 0.0f);
        });
    };
    private static final BlockSearchLogic vein = (level, origin, direction, amount) -> {
        HashSet<BlockPos> hashSet = new HashSet<BlockPos>();
        BlockState originState = level.getBlockState(origin);
        Block originBlock = originState.getBlock();
        if (!originState.is(XyCraftTags.Blocks.NotVeinMineable.tag())) {
            VeinSearch.walk(level, origin, hashSet, 12, false, (pos, state) -> state.is(originBlock) && !state.is(XyCraftTags.Blocks.NotVeinMineable.tag()) && state.getDestroySpeed((BlockGetter)level, pos) >= 0.0f);
        }
        return hashSet.stream();
    };
    private static final BlockSearchLogic tree = (level, origin, direction, amount) -> {
        HashSet<BlockPos> hashSet = new HashSet<BlockPos>();
        BlockState originState = level.getBlockState(origin);
        if (originState.is(BlockTags.LOGS)) {
            HashSet<BlockPos> logs = new HashSet<BlockPos>();
            VeinSearch.walk(level, origin, logs, 256, false, (pos, state) -> state.is(BlockTags.LOGS) && state.getDestroySpeed((BlockGetter)level, pos) >= 0.0f);
            for (BlockPos log : logs) {
                for (Direction value : Direction.values()) {
                    VeinSearch.walk(level, log.relative(value), hashSet, 512, false, (pos, state) -> state.is(BlockTags.LEAVES));
                }
            }
            hashSet.addAll(logs);
        }
        return hashSet.stream().distinct();
    };

    public static MineLogicModule area() {
        return new MineLogicModule(area);
    }

    public static MineLogicModule vein() {
        return new MineLogicModule(vein);
    }

    public static MineLogicModule tree() {
        return new MineLogicModule(tree);
    }

    public static MineLogicModule of(ItemStack stack) {
        IModuleContainer cap = (IModuleContainer)stack.getCapability(IModuleContainer.ITEM);
        return MineLogicModule.of(cap);
    }

    public static MineLogicModule of(IModuleContainer storage) {
        if (storage == null) {
            return null;
        }
        List list = storage.getInstalledModules();
        for (IModuleContainer.ModuleRecord moduleRecord : list) {
            IModule iModule = moduleRecord.module();
            if (!(iModule instanceof MineLogicModule)) continue;
            MineLogicModule found = (MineLogicModule)iModule;
            return found;
        }
        return null;
    }

    public void onAdded(ItemStack storage) {
        IToolModule.super.onAdded(storage);
        storage.set(MachinesDataComponents.ToolActivation, (Object)true);
    }

    public ModuleType getModuleType() {
        return ModuleType.Base;
    }

    public boolean isCompatibleWith(List<IModule> modules) {
        return modules.stream().noneMatch(MineLogicModule.class::isInstance);
    }

    public static Stream<BlockPos> getRadiusBlocks(BlockPos origin, Direction dir, int radius) {
        int yMin = -1;
        int yMax = 2 * radius - 1;
        return switch (dir) {
            case Direction.DOWN, Direction.UP -> BlockPos.betweenClosedStream((BlockPos)origin.offset(-radius, 0, -radius), (BlockPos)origin.offset(radius, 0, radius));
            case Direction.NORTH, Direction.SOUTH -> BlockPos.betweenClosedStream((BlockPos)origin.offset(-radius, yMin, 0), (BlockPos)origin.offset(radius, yMax, 0));
            default -> BlockPos.betweenClosedStream((BlockPos)origin.offset(0, yMin, -radius), (BlockPos)origin.offset(0, yMax, radius));
        };
    }
}

