/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.items;

import com.google.common.base.Suppliers;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import tv.soaryn.xycraft.api.content.xynergy.XynergyNet;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.utils.FastVolumeLookup;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttributes;
import tv.soaryn.xycraft.machines.content.volumes.HoverVolume;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME)
public class HoverPackItem
extends ArmorItem {
    private static final ResourceLocation InsideFieldId = XyCraft.resource((String)"attribute.hover_field.inside");
    private static final ResourceLocation HoverUUID = XyCraft.resource((String)"attribute.hover_flight");
    private final Supplier<ItemAttributeModifiers> defaultModifiers = Suppliers.memoize(() -> {
        ItemAttributeModifiers.Builder itemattributemodifiers$builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)EquipmentSlot.CHEST);
        itemattributemodifiers$builder.add(Attributes.ARMOR, new AttributeModifier(HoverUUID, 2.0, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        itemattributemodifiers$builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(HoverUUID, 1.0, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        itemattributemodifiers$builder.add(MachinesAttributes.HoverFlight, new AttributeModifier(HoverUUID, 1.0, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        return itemattributemodifiers$builder.build();
    });
    private static final AttributeModifier InsideField = new AttributeModifier(InsideFieldId, 1.0, AttributeModifier.Operation.ADD_VALUE);
    private static final ArmorMaterial HoverPackMaterial = new ArmorMaterial(Arrays.stream(ArmorItem.Type.values()).collect(Collectors.toMap(Function.identity(), t -> t != ArmorItem.Type.CHESTPLATE ? 0 : 6)), 0, SoundEvents.ARMOR_EQUIP_TURTLE, () -> Ingredient.EMPTY, List.of(), 4.0f, 0.0f);

    public HoverPackItem(Item.Properties properties) {
        super(Holder.direct((Object)HoverPackMaterial), ArmorItem.Type.CHESTPLATE, properties.setNoRepair().requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get()).stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltips, flags);
        tooltips.add((Component)Component.literal((String)"Provides flight while in a powered Hover Pylon field").withStyle(ChatFormatting.GRAY));
        tooltips.add((Component)Component.literal((String)"Model is Work in Progress").withColor(-4508877));
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    @SubscribeEvent
    private static void onLivingDamage(LivingFallEvent event) {
        AttributeInstance hoverFlight = event.getEntity().getAttribute(MachinesAttributes.HoverFlight);
        if (hoverFlight != null && hoverFlight.getValue() > 0.5 && !event.getEntity().isShiftKeyDown()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    private static void onEndPlayerTick(PlayerTickEvent.Post event) {
        int tickFrequency;
        Player player = event.getEntity();
        Level level = player.level();
        int n = tickFrequency = level.isClientSide() ? 1 : 5;
        if (player.tickCount % tickFrequency != 0) {
            return;
        }
        Abilities abilities = player.getAbilities();
        AttributeInstance creativeFlight = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        AttributeInstance hoverFlight = player.getAttribute(MachinesAttributes.HoverFlight);
        if (hoverFlight == null || creativeFlight == null) {
            return;
        }
        if (hoverFlight.getValue() > 0.5) {
            FastVolumeLookup volumes = FastVolumeLookup.of((Level)level, HoverVolume.class);
            if (HoverPackItem.isInPoweredField(player, level, (FastVolumeLookup<HoverVolume>)volumes)) {
                if (!level.isClientSide()) {
                    if (!creativeFlight.hasModifier(InsideFieldId)) {
                        creativeFlight.addTransientModifier(InsideField);
                    }
                    if (!player.isShiftKeyDown()) {
                        player.resetFallDistance();
                    }
                }
            } else if (!level.isClientSide()) {
                if (creativeFlight.hasModifier(InsideFieldId)) {
                    creativeFlight.removeModifier(InsideField);
                }
                if (!player.isShiftKeyDown()) {
                    player.resetFallDistance();
                }
            } else if (!abilities.flying && !player.isShiftKeyDown()) {
                player.resetFallDistance();
                Vec3 vec3 = player.getDeltaMovement();
                if (vec3.y() < -0.0) {
                    Vector3f delta = vec3.toVector3f();
                    delta.y = Math.max(delta.y(), -0.3f);
                    player.setDeltaMovement((double)delta.x(), (double)delta.y(), (double)delta.z());
                }
            }
        } else if (creativeFlight.hasModifier(InsideFieldId)) {
            creativeFlight.removeModifier(InsideField);
            player.resetFallDistance();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isInPoweredField(Player player, Level level, FastVolumeLookup<HoverVolume> volumes) {
        if (!(level instanceof ServerLevel)) return false;
        ServerLevel serverLevel = (ServerLevel)level;
        if (!volumes.find(player.blockPosition()).anyMatch(hoverVolume -> XynergyNet.hasXynergy((ServerLevel)serverLevel, (BlockPos)hoverVolume.getPos()))) return false;
        return true;
    }
}

