/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.pipe.objects;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.runtime.SwitchBootstraps;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import tv.soaryn.xycraft.api.content.capabilities.IInfoPresenter;
import tv.soaryn.xycraft.api.content.capabilities.IPipeConnection;
import tv.soaryn.xycraft.api.content.capabilities.PipeConnectionType;
import tv.soaryn.xycraft.api.content.pipes.PipeGraphState;
import tv.soaryn.xycraft.api.content.pipes.PipeGroup;
import tv.soaryn.xycraft.api.content.pipes.PipeNetwork;
import tv.soaryn.xycraft.core.content.attachments.memory.CapabilitySidedCacheAttachment;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.core.utils.MathUtils;
import tv.soaryn.xycraft.machines.client.multiblock.ClientPipeGraphCacheAttachment;
import tv.soaryn.xycraft.machines.content.blocks.pipe.BasicPipeConnectionLogic;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeBlock;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.pipe.PipeConnectionAttachment;
import tv.soaryn.xycraft.machines.content.blocks.pipe.objects.DummyFluidStorage;
import tv.soaryn.xycraft.machines.content.multiblock.pipes.FluidPipeGraph;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesCapabilities;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class FluidPipeBlockEntity
extends PipeBlockEntity<IFluidHandler> {
    public FluidPipeBlockEntity(BlockPos pos, BlockState state) {
        super(MachinesContent.Block.PipeFluid.entity(), pos, state, MachinesAttachments.PipeConnectionData.get());
    }

    public static PipeBlock<FluidPipeGraph, IFluidHandler> block(BlockBehaviour.Properties properties) {
        return new PipeBlock<FluidPipeGraph, IFluidHandler>(properties.dynamicShape().noOcclusion(), FluidPipeBlockEntity::new, CoreAttachments.AdjacentFluidCapabilityCache, MachinesAttachments.FluidPipeNetwork);
    }

    @SubscribeEvent
    private static void exposeCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, MachinesContent.Block.PipeFluid.entity(), FluidPipeBlockEntity::getHandler);
        event.registerBlockEntity(MachinesCapabilities.PipeConnection.BLOCK, MachinesContent.Block.PipeFluid.entity(), (blockEntity, context) -> new BasicPipeConnectionLogic((BlockCapability<?, Direction>)Capabilities.FluidHandler.BLOCK, (BlockEntity)blockEntity, 1000L));
        event.registerBlockEntity(CoreCapabilities.WrenchBlock.BLOCK, MachinesContent.Block.PipeFluid.entity(), PipeBlock::handleWrench);
        event.registerBlockEntity(IInfoPresenter.BLOCK, MachinesContent.Block.PipeFluid.entity(), (object, context) -> player -> {
            Level level = player.level();
            BlockPos pos = object.getBlockPos();
            if (!level.isClientSide()) {
                PipeNetwork data = (PipeNetwork)player.level().getData(MachinesAttachments.FluidPipeNetwork);
                FluidPipeGraph graph = (FluidPipeGraph)data.getPipeGraph(pos.asLong());
                if (graph != null) {
                    int color = ((DyeColors)MathUtils.fromArray((int)(Mth.abs((int)graph.id().hashCode()) % 4), (Object[])new DyeColors[]{DyeColors.LightBlue, DyeColors.Lime, DyeColors.Yellow})).getColor();
                    long sum = graph.getAllBuffers().stream().mapToLong(PipeGroup::getStored).sum();
                    player.sendSystemMessage((Component)Component.literal((String)("SER: " + graph.id().toString().substring(0, 13) + " : " + graph.getRouteContainer().RouteGraph.vertexSet().size() + " pipes : ")).withColor(color).append(graph.Filter.getHoverName()).append(" ").append((Component)Component.literal((String)("" + graph.getAllBuffers().stream().mapToLong(PipeGroup::getStored).sum()))));
                }
            } else {
                Graph graph;
                ClientPipeGraphCacheAttachment data = (ClientPipeGraphCacheAttachment)level.getData(MachinesAttachments.FluidPipeClientCache);
                UUID id = (UUID)data.PosToId.get(pos.asLong());
                if (id != null && (graph = (Graph)data.IdToGraph.get((Object)id)) != null) {
                    int color = ((DyeColors)MathUtils.fromArray((int)(Mth.abs((int)id.hashCode()) % 4), (Object[])new DyeColors[]{DyeColors.LightBlue, DyeColors.Lime, DyeColors.Yellow})).getColor();
                    ClientPipeGraphCacheAttachment.ClientBuffer buffer = (ClientPipeGraphCacheAttachment.ClientBuffer)data.IdToData.getOrDefault((Object)id, (Object)ClientPipeGraphCacheAttachment.ClientBuffer.Empty);
                    player.sendSystemMessage((Component)Component.literal((String)("CLI: " + id.toString().substring(0, 13) + " : " + graph.vertexSet().size() + " pipes : ")).withColor(color).append(buffer.Fluid.getHoverName()).append(" ").append((Component)Component.literal((String)("" + buffer.Amount))));
                }
            }
        });
    }

    @Nullable
    private static IFluidHandler getHandler(final BlockEntity pipe, Direction context) {
        ServerLevel level;
        block13: {
            block12: {
                Level level2 = pipe.getLevel();
                if (!(level2 instanceof ServerLevel)) break block12;
                level = (ServerLevel)level2;
                if (context != null) break block13;
            }
            return null;
        }
        PipeConnectionAttachment data = (PipeConnectionAttachment)pipe.getData(MachinesAttachments.PipeConnectionData);
        IPipeConnection pipeCap = (IPipeConnection)level.getCapability(IPipeConnection.BLOCK, pipe.getBlockPos(), null);
        if (pipeCap == null) {
            return null;
        }
        if (pipeCap.isClosed(context)) {
            return new DummyFluidStorage();
        }
        if (data.map() == null) {
            return null;
        }
        PipeConnectionType pipeConnectionType = (PipeConnectionType)data.map().get((Object)context);
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"None", "Insert", "Transfer", "Extract"}, (PipeConnectionType)pipeConnectionType, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> null;
            case 0 -> null;
            case 1 -> new DummyFluidStorage();
            case 2, 3 -> new IFluidHandler(){

                public int getTanks() {
                    return 1;
                }

                @NotNull
                public FluidStack getFluidInTank(int tank) {
                    FluidPipeGraph graph = (FluidPipeGraph)((PipeNetwork)level.getData(MachinesAttachments.FluidPipeNetwork)).getPipeGraph(pipe.getBlockPos().asLong());
                    if (graph == null) {
                        return FluidStack.EMPTY;
                    }
                    ObjectArraySet buffers = graph.initBufferAllowances(level, pipe.getBlockPos().asLong());
                    if (graph.Filter.isEmpty()) {
                        return FluidStack.EMPTY;
                    }
                    return graph.Filter.copyWithAmount(MathUtils.toInt((long)buffers.stream().mapToLong(PipeGroup::getStored).sum()));
                }

                public int getTankCapacity(int tank) {
                    FluidPipeGraph graph = (FluidPipeGraph)((PipeNetwork)level.getData(MachinesAttachments.FluidPipeNetwork)).getPipeGraph(pipe.getBlockPos().asLong());
                    if (graph == null) {
                        return 0;
                    }
                    ObjectArraySet buffers = graph.initBufferAllowances(level, pipe.getBlockPos().asLong());
                    return MathUtils.toInt((long)buffers.stream().mapToLong(PipeGroup::getAcceptanceBuffer).sum());
                }

                public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                    FluidPipeGraph graph = (FluidPipeGraph)((PipeNetwork)level.getData(MachinesAttachments.FluidPipeNetwork)).getPipeGraph(pipe.getBlockPos().asLong());
                    if (graph == null) {
                        return false;
                    }
                    return graph.Filter.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)graph.Filter, (FluidStack)stack);
                }

                public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
                    int amount;
                    FluidPipeGraph graph = (FluidPipeGraph)((PipeNetwork)level.getData(MachinesAttachments.FluidPipeNetwork)).getPipeGraph(pipe.getBlockPos().asLong());
                    if (graph == null || graph.state() != PipeGraphState.READY) {
                        return 0;
                    }
                    if (!graph.Filter.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)graph.Filter, (FluidStack)resource)) {
                        return 0;
                    }
                    FluidStack tempFilter = graph.Filter.copy();
                    if (graph.Filter.isEmpty()) {
                        graph.Filter = resource.copyWithAmount(Integer.MAX_VALUE);
                    }
                    ObjectArraySet buffers = graph.initBufferAllowances(level, pipe.getBlockPos().asLong());
                    int inject = amount = resource.getAmount();
                    boolean hasStored = false;
                    for (PipeGroup b : buffers) {
                        if (inject == 0) break;
                        if (b.Stored > 0L && action.execute()) {
                            hasStored = true;
                        }
                        if (b.AcceptanceBuffer == 0L) continue;
                        int injected = MathUtils.toInt((long)Math.min((long)inject, b.AcceptanceBuffer));
                        inject -= injected;
                        if (action.simulate()) continue;
                        b.AcceptanceBuffer -= (long)injected;
                        b.Stored += (long)injected;
                        if (b.Stored <= 0L) continue;
                        hasStored = true;
                    }
                    int result = amount - inject;
                    if (action.simulate() || result == 0 && !hasStored) {
                        graph.Filter = tempFilter;
                    }
                    return result;
                }

                @NotNull
                public FluidStack drain(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }

                @NotNull
                public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
                    return FluidStack.EMPTY;
                }
            };
        };
    }

    @Override
    public Supplier<AttachmentType<CapabilitySidedCacheAttachment<IFluidHandler>>> getCapCache() {
        return CoreAttachments.AdjacentFluidCapabilityCache;
    }
}

