/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.isolator;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNode;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNodeClient;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.recipes.energy.isolator.IsolatorRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class IsolatorBlock
extends SidePartBlock.WithEntity
implements IColoredBlock {
    public static final AttachmentType.Builder<Attachment> BUILDER = AttachmentType.builder(Attachment::create);
    public static final Vector3f[] renderOffset = (Vector3f[])Util.make((Object)new Vector3f[6], array -> Arrays.setAll(array, i -> {
        Vector3f offset = new Vector3f(0.0f, 1.0f, 0.0f);
        Direction dir = Direction.from3DDataValue((int)i);
        Vec3i normal = dir.getNormal();
        return offset.rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, -1.0f, 0.0f, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ()));
    }));

    public IsolatorBlock(BlockBehaviour.Properties properties) {
        super(properties, Entity::new);
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltips, flag);
        tooltips.add((Component)Component.literal((String)"ForgeCraft specific block. It will be replaced later").withColor(-13391173));
        if (Utils.SHIFT_KEY_DOWN.getAsBoolean()) {
            tooltips.add((Component)Component.literal((String)"Place on something like Magma Blocks or Fluix Blocks to produce Xynergy. Currently, Xynergy is only used for the hover pylon in game which will need to be bound to this block or other nodes with a stick or `c:tools/wrench`.").withStyle(ChatFormatting.GRAY));
        } else {
            tooltips.add((Component)Component.literal((String)"[SHIFT]").withStyle(style -> style.withColor(ChatFormatting.GRAY).withBold(Boolean.valueOf(true))).append((Component)Component.literal((String)" for more info...").withStyle(style -> style.withColor(ChatFormatting.GRAY).withBold(Boolean.valueOf(false)))));
        }
    }

    public VoxelShape getDownShapeForBaking() {
        return IsolatorBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(CoreCapabilities.XynergyNode.BLOCK, MachinesContent.Block.Isolator.entity(), (blockEntity, context) -> new IXynergyNode((BlockEntity)blockEntity){
            final /* synthetic */ BlockEntity val$blockEntity;
            {
                this.val$blockEntity = blockEntity;
            }

            public long getValue() {
                Level level = this.val$blockEntity.getLevel();
                if (level == null) {
                    return 0L;
                }
                Optional holder = ((Attachment)this.val$blockEntity.getData(MachinesAttachments.IsolatorCache)).check().getRecipeFor((RecipeInput)((IsolatorRecipe.Input)() -> level.getBlockState(this.val$blockEntity.getBlockPos().relative(SidePartBlock.directionOf((BlockState)this.val$blockEntity.getBlockState())))), level);
                return holder.map(isolatorRecipeRecipeHolder -> ((IsolatorRecipe)isolatorRecipeRecipeHolder.value()).xynergy()).orElse(0L);
            }

            public byte getEdgeLimit() {
                return 2;
            }
        });
        event.registerBlock(CoreCapabilities.XynergyNode.BLOCK_CLIENT, (level, pos, state, blockEntity, context) -> new IXynergyNodeClient(){
            private static final Vector3f[] _offset = (Vector3f[])Util.make((Object)new Vector3f[6], vector3fs -> {
                for (int i = 0; i < Direction.values().length; ++i) {
                    Vec3i normal = Direction.values()[i].getNormal();
                    vector3fs[i] = new Vector3f(0.0f, 0.5f, 0.0f).rotate((Quaternionfc)new Quaternionf().rotateTo(0.0f, -1.0f, 0.0f, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ()));
                }
            });

            @NotNull
            public Vector3f getRenderOffset(BlockPos otherNode) {
                return _offset[((Direction)level.getBlockState(pos).getValue((Property)CoreStateProperties.StateDirection)).get3DDataValue()];
            }

            public boolean hasRenderNode(BlockPos otherNode) {
                return true;
            }

            public int getColor() {
                return 857927304;
            }
        }, new Block[]{MachinesContent.Block.Isolator.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.Isolator.block()});
    }

    public static class Entity
    extends XyBlockEntity {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.Isolator.entity(), pos, state, new AttachmentType[0]);
        }
    }

    public record Attachment(RecipeManager.CachedCheck<IsolatorRecipe.Input, IsolatorRecipe> check) {
        public static Attachment create() {
            return new Attachment((RecipeManager.CachedCheck<IsolatorRecipe.Input, IsolatorRecipe>)RecipeManager.createCheck((RecipeType)((RecipeType)MachinesRecipeTypes.Isolator.type().get())));
        }
    }
}

