/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.fabricator;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.capabilities.IColorable;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlockEntity;
import tv.soaryn.xycraft.core.content.capabilities.ColorableCapability;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.attachments.FabricatorAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;
import tv.soaryn.xycraft.machines.gui.FabricatorMenu;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class FabricatorBlock
extends XyBlock.WithEntity
implements IColoredBlock,
ITooltipProvider.BlockDefault {
    public FabricatorBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().randomTicks(), Entity::new);
        this.registerSystem(MachinesSystems.Fabricator);
        this.registerHasCapability();
    }

    public boolean canConnectRedstone(@NotNull BlockState state, BlockGetter level, @NotNull BlockPos pos, @Nullable Direction direction) {
        return ((Direction)level.getBlockState(pos).getValue((Property)CoreStateProperties.StateDirection)).getOpposite() != direction;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{CoreStateProperties.StateDirection});
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getClickedFace();
        if (ModifierKey.of((Player)ctx.getPlayer())) {
            direction = direction.getOpposite();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.StateDirection, (Comparable)direction);
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!level.isClientSide() && be instanceof Entity) {
            Entity fabricator = (Entity)be;
            if (!player.isFakePlayer()) {
                player.openMenu((MenuProvider)fabricator, be.getBlockPos());
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    @SubscribeEvent
    private static void attachCapability(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, context) -> {
            Direction direction = (Direction)level.getBlockState(pos).getValue((Property)CoreStateProperties.StateDirection);
            return blockEntity != null && direction != context ? ((FabricatorAttachment)blockEntity.getData(MachinesAttachments.FabricatorData)).ItemHandler : null;
        }, new Block[]{MachinesContent.Block.Fabricator.block()});
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, ColorableCapability::registerBlock, new Block[]{MachinesContent.Block.Fabricator.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.Fabricator.block()});
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        BlockEntity blockEntity;
        Player player;
        block5: {
            block4: {
                super.setPlacedBy(level, pos, state, entity, stack);
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof Entity) break block5;
            }
            return;
        }
        Entity fabricator = (Entity)blockEntity;
        DyeColor dye = DyeColor.getColor((ItemStack)player.getOffhandItem());
        IColorable cap = (IColorable)level.getCapability(CoreCapabilities.Colorable.BLOCK, pos, null);
        if (cap != null) {
            cap.setColor(0, dye == null ? FavoredColor.of((IAttachmentHolder)player) : ColorUtils.getColorFromDye((DyeColor)dye));
            fabricator.setChanged();
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean moving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof Entity) {
            Entity entity = (Entity)blockEntity;
            FabricatorAttachment data = (FabricatorAttachment)entity.getData(MachinesAttachments.FabricatorData);
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)data.Storage.asVanillaContainer());
        }
        super.onRemove(state, level, pos, newState, moving);
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        BlockEntity blockEntity;
        if (level == null || !((blockEntity = level.getBlockEntity(pos)) instanceof BlockEntity)) {
            return super.getColorOfBlock(state, level, pos, index);
        }
        BlockEntity blockEntity2 = blockEntity;
        FabricatorAttachment data = (FabricatorAttachment)blockEntity2.getData(MachinesAttachments.FabricatorData);
        int color = FavoredColor.of((IAttachmentHolder)blockEntity2);
        return data.canCraft() ? color : ColorUtils.multiply((int)color, (float)0.4f);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return FavoredColor.of((IAttachmentHolder)Utils.getClientPlayer());
    }

    public static class Entity
    extends XyBlockEntity.WithMenu
    implements MenuProvider {
        public Entity(BlockPos pos, BlockState state) {
            super(MachinesContent.Block.Fabricator.entity(), "block.xycraft_machines.fabricator", pos, state, new AttachmentType[]{(AttachmentType)CoreAttachments.Color.get(), MachinesAttachments.FabricatorData.get()});
        }

        public void onLoad() {
            Level level = this.getLevel();
            if (level == null) {
                return;
            }
            FabricatorAttachment data = (FabricatorAttachment)this.getData(MachinesAttachments.FabricatorData);
            data.invalidateRecipeCache();
            super.onLoad();
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerEntity) {
            FabricatorAttachment data = (FabricatorAttachment)this.getData(MachinesAttachments.FabricatorData);
            return new FabricatorMenu(windowId, playerInventory, (BlockEntity)this, data.Storage, data.Ghost, (ContainerData)data.MenuData);
        }
    }
}

