/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.extractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.core.content.attachments.ProcessingDataAttachment;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.ITooltipProvider;
import tv.soaryn.xycraft.core.content.blocks.SidePartBlock;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.machines.content.attachments.ExtractorAttachment;
import tv.soaryn.xycraft.machines.content.blocks.extractor.ExtractorBlockEntity;
import tv.soaryn.xycraft.machines.content.blocks.properties.IOMode;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStateProperties;
import tv.soaryn.xycraft.machines.content.blocks.properties.MachineStatusColors;
import tv.soaryn.xycraft.machines.content.recipes.producers.extractor.ExtractorRecipe;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.content.registries.MachinesRecipeTypes;
import tv.soaryn.xycraft.machines.content.registries.MachinesSystems;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class ExtractorBlock
extends SidePartBlock.WithEntity
implements IColoredBlock,
ITooltipProvider.BlockDefault {
    public ExtractorBlock(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion().randomTicks(), ExtractorBlockEntity::new);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Error))).setValue(MachineStateProperties.IOMode, (Comparable)((Object)IOMode.Item)));
        this.registerSystem(MachinesSystems.Extractor);
        this.registerHasCapability();
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{MachineStateProperties.Status});
        builder.add(new Property[]{MachineStateProperties.IOMode});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        final BlockState state = super.getStateForPlacement(ctx);
        if (state == null) {
            return null;
        }
        final Level level = ctx.getLevel();
        List recipeList = level.getRecipeManager().getAllRecipesFor((RecipeType)MachinesRecipeTypes.Extractor.type().get());
        final Direction direction = (Direction)state.getValue((Property)CoreStateProperties.StateDirection);
        final BlockPos targetPos = ctx.getClickedPos().relative(direction);
        final BlockPos catalystPos = ctx.getClickedPos().relative(direction, 2);
        final BlockPos[] adjacentPositions = new BlockPos[4];
        int i = 0;
        for (Direction d : Direction.values()) {
            if (d.getAxis() == direction.getAxis()) continue;
            adjacentPositions[i++] = targetPos.relative(d);
        }
        ExtractorRecipe.Input container = new ExtractorRecipe.Input(){

            @Override
            public Direction getDirection() {
                return direction;
            }

            @Override
            public FluidState getFluidState() {
                return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.defaultFluidState() : Fluids.EMPTY.defaultFluidState();
            }

            @Override
            public BlockState getTarget() {
                return level.getBlockState(targetPos);
            }

            @Override
            public BlockState getCatalyst() {
                return level.getBlockState(catalystPos);
            }

            @Override
            public List<BlockState> computeAdjacent() {
                return Arrays.stream(adjacentPositions).map(arg_0 -> ((Level)level).getBlockState(arg_0)).collect(Collectors.toCollection(ArrayList::new));
            }
        };
        Optional<RecipeHolder> recipeOptional = recipeList.stream().filter(arg_0 -> ExtractorBlock.lambda$getStateForPlacement$0(container, level, arg_0)).max(ExtractorAttachment::compareAdjacentCounts);
        if (recipeOptional.isEmpty()) {
            recipeOptional = recipeList.stream().filter(arg_0 -> ExtractorBlock.lambda$getStateForPlacement$1(container, level, arg_0)).max(ExtractorAttachment::compareAdjacentCounts);
        }
        BlockState newState = state;
        if (recipeOptional.isPresent()) {
            boolean signal;
            boolean isFluidRecipe = ((ExtractorRecipe)recipeOptional.get().value()).isFluidRecipe();
            if (isFluidRecipe) {
                newState = (BlockState)newState.setValue(MachineStateProperties.IOMode, (Comparable)((Object)IOMode.Fluid));
            }
            if (signal = level.hasNeighborSignal(ctx.getClickedPos())) {
                return (BlockState)newState.setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Off));
            }
            newState = (BlockState)newState.setValue(MachineStateProperties.Status, (Comparable)((Object)MachineStatusColors.Success));
        }
        return newState;
    }

    public VoxelShape getDownShapeForBaking() {
        VoxelShape column = ExtractorBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        return Shapes.or((VoxelShape)column, (VoxelShape)ExtractorBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0));
    }

    public void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean p_54758_) {
        BlockEntity blockEntity;
        ServerLevel serverLevel;
        block3: {
            block2: {
                super.onPlace(blockState, level, pos, oldState, p_54758_);
                if (!(level instanceof ServerLevel)) break block2;
                serverLevel = (ServerLevel)level;
                blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof ExtractorBlockEntity) break block3;
            }
            return;
        }
        ExtractorBlockEntity extractor = (ExtractorBlockEntity)blockEntity;
        ProcessingDataAttachment data = (ProcessingDataAttachment)extractor.getData(CoreAttachments.ProcessingData);
        ExtractorAttachment.checkForValidRecipe(serverLevel, pos, blockState, extractor, data);
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, context) -> {
            if (level.getBlockState(pos).getValue(MachineStateProperties.IOMode) != IOMode.Item || blockEntity == null || context == null || SidePartBlock.isInaccessibleSide((Direction)context.getOpposite(), (BlockState)state)) {
                return null;
            }
            return ((ExtractorAttachment)blockEntity.getData(MachinesAttachments.ExtractorData)).ItemHandler;
        }, new Block[]{MachinesContent.Block.Extractor.block()});
        event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, blockEntity, context) -> {
            if (level.getBlockState(pos).getValue(MachineStateProperties.IOMode) != IOMode.Fluid || blockEntity == null || context == null || SidePartBlock.isInaccessibleSide((Direction)context.getOpposite(), (BlockState)state)) {
                return null;
            }
            return ((ExtractorAttachment)blockEntity.getData(MachinesAttachments.ExtractorData)).FluidHandler;
        }, new Block[]{MachinesContent.Block.Extractor.block()});
        event.registerBlock(CoreCapabilities.WrenchBlock.BLOCK, WrenchCapability::registerCommonRotate, new Block[]{MachinesContent.Block.Extractor.block()});
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        return this.getColor((MachineStatusColors)((Object)state.getValue(MachineStateProperties.Status)), index);
    }

    private int getColor(MachineStatusColors status, int index) {
        return index == 1 ? status.Color : -1;
    }

    public int getColorOfItem(ItemStack stack, int index) {
        return this.getColor(MachineStatusColors.Success, index);
    }

    private static /* synthetic */ boolean lambda$getStateForPlacement$1(1 container, Level level, RecipeHolder holder) {
        return ((ExtractorRecipe)holder.value()).catalyst().isEmpty() && ((ExtractorRecipe)holder.value()).matches(container, level);
    }

    private static /* synthetic */ boolean lambda$getStateForPlacement$0(1 container, Level level, RecipeHolder holder) {
        return ((ExtractorRecipe)holder.value()).catalyst().isPresent() && ((ExtractorRecipe)holder.value()).matches(container, level);
    }
}

