/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks.basic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.IFluidSpreadPreventer;
import tv.soaryn.xycraft.core.utils.handlers.VoidFluidHandler;
import tv.soaryn.xycraft.machines.XyMachines;

public class FluidVoidBlock
extends ColoredBlock
implements IFluidSpreadPreventer {
    public FluidVoidBlock(BlockBehaviour.Properties properties) {
        super((IColorSource)XyCraftColors.Dark, properties);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.isCreative()) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        return (Boolean)XyMachines.ServerConfig.FluidVoidEmptiesContainer.get() != false && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)VoidFluidHandler.INSTANCE) ? ItemInteractionResult.sidedSuccess((boolean)level.isClientSide()) : super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState otherState, boolean flag) {
        super.onPlace(state, level, pos, otherState, flag);
        this.removeFluid(level, pos);
    }

    public boolean canBeHydrated(@NotNull BlockState state, @NotNull BlockGetter getter, @NotNull BlockPos pos, @NotNull FluidState fluid, @NotNull BlockPos fluidPos) {
        return true;
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState otherState, boolean flag) {
        super.onRemove(state, level, pos, otherState, flag);
        for (Direction d : Direction.values()) {
            BlockPos targetPos = pos.relative(d);
            BlockState targetState = level.getBlockState(targetPos);
            level.markAndNotifyBlock(targetPos, level.getChunkAt(targetPos), targetState, targetState, 3, 512);
        }
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block temp, @NotNull BlockPos otherPos, boolean flag) {
        BucketPickup bucketpickup;
        BlockState otherState = level.getBlockState(otherPos);
        Block block = otherState.getBlock();
        if (block instanceof BucketPickup && !(bucketpickup = (BucketPickup)block).pickupBlock(null, (LevelAccessor)level, otherPos, otherState).isEmpty()) {
            return;
        }
        if (block instanceof LiquidBlock) {
            level.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 3);
        }
        super.neighborChanged(state, level, pos, block, otherPos, flag);
    }

    public void removeFluid(@NotNull Level level, BlockPos pos) {
        boolean hasDrained = false;
        for (Direction direction : Direction.values()) {
            BucketPickup bucketpickup;
            BlockPos otherPos = pos.relative(direction);
            BlockState otherState = level.getBlockState(otherPos);
            Block block = otherState.getBlock();
            if (block instanceof BucketPickup && !(bucketpickup = (BucketPickup)block).pickupBlock(null, (LevelAccessor)level, otherPos, otherState).isEmpty()) {
                hasDrained = true;
                continue;
            }
            if (!(block instanceof LiquidBlock)) {
                if (otherState.getFluidState().isEmpty()) continue;
                BlockEntity blockentity = otherState.hasBlockEntity() ? level.getBlockEntity(otherPos) : null;
                FluidVoidBlock.dropResources((BlockState)otherState, (LevelAccessor)level, (BlockPos)otherPos, (BlockEntity)blockentity);
            }
            level.setBlock(otherPos, Blocks.AIR.defaultBlockState(), 3);
            hasDrained = true;
        }
        if (!hasDrained) {
            return;
        }
        SoundEvent soundevent = Fluids.WATER.getFluidType().getSound(SoundActions.BUCKET_FILL);
        if (soundevent != null) {
            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

