/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.blocks;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.XyCraftColors;
import tv.soaryn.xycraft.api.content.capabilities.IColorable;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNode;
import tv.soaryn.xycraft.api.content.capabilities.IXynergyNodeClient;
import tv.soaryn.xycraft.core.content.attachments.accessors.FavoredColor;
import tv.soaryn.xycraft.core.content.blocks.IColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.XyBlock;
import tv.soaryn.xycraft.core.content.capabilities.ColorableCapability;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.machines.content.attachments.level.PowerCoreMapLevelAttachment;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class PowerCoreBlock
extends XyBlock
implements IColoredBlock,
SimpleWaterloggedBlock {
    public static final VoxelShape box = PowerCoreBlock.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public PowerCoreBlock(BlockBehaviour.Properties properties) {
        super(properties.destroyTime(0.0f).noOcclusion().lightLevel(value -> 15).requiredFeatures((FeatureFlag[])Utils.EXPERIMENTAL_FLAG.get()));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState other, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos otherPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, other, level, pos, otherPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidstate = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public PushReaction getPistonPushReaction(@NotNull BlockState state) {
        return PushReaction.DESTROY;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity entity, @NotNull ItemStack stack) {
        IColorable cap;
        super.setPlacedBy(level, pos, state, entity, stack);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        DyeColor dye = DyeColor.getColor((ItemStack)entity.getOffhandItem());
        if (dye == null) {
            dye = DyeColor.getColor((ItemStack)entity.getMainHandItem());
        }
        if ((cap = ColorableCapability.of((Level)level, (BlockPos)pos)) == null) {
            return;
        }
        cap.setColor(0, dye == null ? FavoredColor.of((IAttachmentHolder)player) : ColorUtils.getColorFromDye((DyeColor)dye));
    }

    public void onPlace(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean p_54758_) {
        super.onPlace(blockState, level, pos, newState, p_54758_);
        PowerCoreMapLevelAttachment data = (PowerCoreMapLevelAttachment)level.getData(MachinesAttachments.PowerCoreMapData);
        if (data.hasCore(pos)) {
            return;
        }
        data.setCore(pos, XyCraftColors.Blue.getColor());
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean moving) {
        super.onRemove(state, level, pos, oldState, moving);
        if (oldState.is(state.getBlock())) {
            return;
        }
        PowerCoreMapLevelAttachment data = (PowerCoreMapLevelAttachment)level.getData(MachinesAttachments.PowerCoreMapData);
        data.removeCore(pos);
    }

    public boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext context) {
        return false;
    }

    public boolean canBeReplaced(@NotNull BlockState p_60535_, @NotNull Fluid p_60536_) {
        return false;
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        int n;
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            n = ((PowerCoreMapLevelAttachment)clientLevel.getData(MachinesAttachments.PowerCoreMapData)).getBreakColor(pos);
        } else {
            n = super.getColorOfBlock(state, level, pos, index);
        }
        return n;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return box;
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(CoreCapabilities.XynergyNode.BLOCK, (level, pos, state, blockEntity, context) -> new IXynergyNode(){

            public long getValue() {
                return 0L;
            }

            public byte getEdgeLimit() {
                return 8;
            }
        }, new Block[]{MachinesContent.Block.PowerCore.block()});
        event.registerBlock(CoreCapabilities.XynergyNode.BLOCK_CLIENT, (level, pos, state, blockEntity, context) -> new IXynergyNodeClient(){

            public int getColor() {
                PowerCoreMapLevelAttachment data = (PowerCoreMapLevelAttachment)level.getData(MachinesAttachments.PowerCoreMapData);
                return data.getColor(pos);
            }

            public boolean hasRenderNode(BlockPos otherNode) {
                return true;
            }

            public float getRenderNodeSize() {
                return 0.9f;
            }
        }, new Block[]{MachinesContent.Block.PowerCore.block()});
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, (level, pos, state, blockEntity, context) -> new IColorable(){

            public int getColor(int index) {
                PowerCoreMapLevelAttachment data = (PowerCoreMapLevelAttachment)level.getData(MachinesAttachments.PowerCoreMapData);
                return data.getColor(pos);
            }

            @NotNull
            public IColorable.Result setColor(int index, int value) {
                PowerCoreMapLevelAttachment data = (PowerCoreMapLevelAttachment)level.getData(MachinesAttachments.PowerCoreMapData);
                if (data.getColor(pos) == value) {
                    return IColorable.Result.DENIED;
                }
                data.setCore(pos, value);
                return IColorable.Result.SUCCESS;
            }
        }, new Block[]{MachinesContent.Block.PowerCore.block()});
    }
}

