/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.content.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;

public class BalloonStakeAttachment {
    public static final Codec<BalloonStakeAttachment> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("bound").forGetter(data -> data._bound), (App)Codec.INT.fieldOf("id").forGetter(data -> data._id)).apply((Applicative)builder, BalloonStakeAttachment::new));
    public static final AttachmentType.Builder<BalloonStakeAttachment> builder = AttachmentType.builder(BalloonStakeAttachment::new).serialize(CODEC);
    private boolean _bound;
    private int _id;
    private Player _targetPlayer = null;

    private BalloonStakeAttachment() {
    }

    private BalloonStakeAttachment(boolean bound, int id) {
        this._bound = bound;
        this._id = id;
    }

    public Player getPlayer(Level level) {
        Entity entity;
        if (level == null) {
            return this._targetPlayer;
        }
        if (this._targetPlayer == null && (entity = level.getEntity(this._id)) instanceof Player) {
            Player player;
            this._targetPlayer = player = (Player)entity;
        }
        return this._targetPlayer;
    }

    public void setPlayer(Player player) {
        this._targetPlayer = player;
    }

    public boolean isBound() {
        return this._bound;
    }

    public void setIsBound(boolean value) {
        this._bound = value;
    }

    public int getBoundId() {
        return this._id;
    }

    public void setBoundId(int value) {
        this._id = value;
        if (value == -1) {
            this._targetPlayer = null;
        }
    }
}

