/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.compat.viewers.jade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IElement;
import snownee.jade.overlay.DisplayHelper;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.config.CoreClientConfig;
import tv.soaryn.xycraft.core.utils.serialization.CodecUtils;

public enum TankComponentProvider implements IBlockComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        JadeTankInfo tank = (JadeTankInfo)JadeTankInfo.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)blockAccessor.getServerData()).mapOrElse(Pair::getFirst, pairError -> null);
        if (tank == null) {
            return;
        }
        MutableComponent component = Component.literal((String)"Tank").withStyle(ChatFormatting.WHITE);
        if (!tank.fluidStack.isEmpty()) {
            component.append(": ").append((Component)tank.fluidStack.getHoverName().copy().withColor(-5592406));
        }
        iTooltip.replace(JadeIds.CORE_OBJECT_NAME, (Component)component);
        IElement tankElement = new TankElement(tank).size(new Vec2(132.0f, 24.0f));
        iTooltip.add(tankElement);
    }

    public ResourceLocation getUid() {
        return XyCraft.resource((String)"tank_component");
    }

    public record JadeTankInfo(FluidStack fluidStack, int Capacity) {
        public static final Codec<JadeTankInfo> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CodecUtils.Codecs.FLUID_STACK_OPTIONAL.fieldOf("fluid").forGetter(JadeTankInfo::fluidStack), (App)Codec.INT.fieldOf("capacity").forGetter(JadeTankInfo::Capacity)).apply((Applicative)builder, JadeTankInfo::new));
    }

    public static class TankElement
    extends Element {
        private final JadeTankInfo _tank;
        private final JadeFluidObject _fluid;

        public TankElement(JadeTankInfo tank) {
            Objects.requireNonNull(tank);
            Objects.requireNonNull(tank.fluidStack);
            this._tank = tank;
            this._fluid = JadeFluidObject.of((Fluid)tank.fluidStack.getFluid(), (long)tank.fluidStack.getAmount(), (DataComponentPatch)tank.fluidStack.getComponentsPatch());
        }

        public Vec2 getSize() {
            return this.size;
        }

        public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
            MutableComponent storedAmount;
            DecimalFormat formatter = new DecimalFormat(",##0");
            CoreClientConfig.MeasuringUnit unit = (CoreClientConfig.MeasuringUnit)XyCore.ClientConfig.FluidUnit.get();
            long amount = this._fluid.getAmount();
            String capacityFormatted = formatter.format((double)this._tank.Capacity / 1000.0) + " " + unit.Unit;
            MutableComponent storedTranslation = Component.translatable((String)"Stored:");
            MutableComponent capacityTranslation = Component.translatable((String)"Capacity:");
            Font font = Minecraft.getInstance().font;
            int horizontalOffset = 26;
            boolean verticalOffset = true;
            int offset = 6 + Math.max(font.width((FormattedText)capacityTranslation), font.width((FormattedText)storedTranslation));
            int dif = 0;
            if (amount > 0L) {
                storedAmount = Component.literal((String)"%s %s".formatted(formatter.format(Math.floor((double)amount / 1000.0)), unit.Unit));
                dif = font.width(capacityFormatted) - font.width((FormattedText)storedAmount);
            } else {
                storedAmount = Component.translatable((String)"Empty");
            }
            DisplayHelper.INSTANCE.drawFluid(guiGraphics, x, y, this._fluid, 22.0f, 22.0f, JadeFluidObject.bucketVolume());
            DisplayHelper.INSTANCE.drawBorder(guiGraphics, x, y, x + 22.0f, y + 22.0f, 1.0f, -1436129690, true);
            DisplayHelper.INSTANCE.drawText(guiGraphics, (FormattedText)storedTranslation, x + (float)horizontalOffset, y + (float)verticalOffset, -13210);
            DisplayHelper.INSTANCE.drawText(guiGraphics, (FormattedText)capacityTranslation, x + (float)horizontalOffset, y + (float)verticalOffset + 12.0f, -8930305);
            DisplayHelper.INSTANCE.drawText(guiGraphics, (FormattedText)storedAmount, x + (float)horizontalOffset + (float)offset + (float)dif, y + (float)verticalOffset, -7829368);
            DisplayHelper.INSTANCE.drawText(guiGraphics, capacityFormatted, x + (float)horizontalOffset + (float)offset, y + (float)verticalOffset + 12.0f, -7829368);
        }
    }
}

