/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.api.content.capabilities.modular.IEnergyConsumer;
import tv.soaryn.xycraft.api.content.capabilities.modular.IModuleContainer;
import tv.soaryn.xycraft.core.XyCore;
import tv.soaryn.xycraft.core.content.attachments.accessors.ModifierKey;
import tv.soaryn.xycraft.core.content.attachments.accessors.PlayerPowerLookup;
import tv.soaryn.xycraft.core.content.attachments.memory.PlayerPowerItemLookupAttachment;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.ui.widgets.drawable.DrawableImage;
import tv.soaryn.xycraft.core.utils.Utils;
import tv.soaryn.xycraft.core.utils.handlers.EnergyHandlerUtils;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class EnergyTooltipHelper {
    @SubscribeEvent
    static void renderTooltip(RenderTooltipEvent.GatherComponents event) {
        IModuleContainer moduleStorage;
        ItemStack stack = event.getItemStack();
        if (stack.isEmpty()) {
            return;
        }
        Player player = Utils.getClientPlayer();
        if (player == null) {
            return;
        }
        IEnergyConsumer cap = (IEnergyConsumer)stack.getCapability(CoreCapabilities.EnergyConsumable.ITEM);
        ArrayList elements = new ArrayList(event.getTooltipElements());
        event.getTooltipElements().clear();
        event.getTooltipElements().add((Either)elements.removeFirst());
        if (cap != null) {
            int amount = cap.amountRequired(player);
            int full = -39322;
            int alpha = -1996528026;
            PlayerPowerItemLookupAttachment lookup = PlayerPowerLookup.of((Player)player);
            if (player.isCreative() || lookup.loop((long)amount, EnergyHandlerUtils::simulateDrain) >= (long)amount) {
                full = -10027162;
                alpha = -2006515866;
            }
            event.getTooltipElements().add(XynergyConsumerTooltip.create(amount, full, alpha));
        }
        if ((moduleStorage = (IModuleContainer)stack.getCapability(IModuleContainer.ITEM)) != null && moduleStorage.getInstalledModules().stream().anyMatch(moduleRecord -> moduleRecord.module() != null) && ModifierKey.of((Player)player)) {
            List modules = moduleStorage.getInstalledModules();
            for (IModuleContainer.ModuleRecord module : modules) {
                if (module.module() == null) continue;
                event.getTooltipElements().add(Either.left((Object)Component.literal((String)" ").append((Component)module.stack().getDisplayName().copy().withStyle(Style.EMPTY.withColor(module.module().getModuleType().SubTextColor)))));
            }
        }
        event.getTooltipElements().addAll(elements);
    }

    public record XynergyConsumerTooltip(int amount, int full, int alpha) implements TooltipComponent
    {
        public static Either<FormattedText, TooltipComponent> create(int amount, int full, int alpha) {
            return Either.right((Object)new XynergyConsumerTooltip(amount, full, alpha));
        }
    }

    public record XynergyConsumerTooltipClient(XynergyConsumerTooltip value) implements ClientTooltipComponent
    {
        private static final ResourceLocation glow = XyCore.resource((String)"textures/gui/icons/xynergy_glow.png");
        private static final ResourceLocation bolt = XyCore.resource((String)"textures/gui/icons/xynergy.png");
        private static DrawableImage inner;
        private static final DrawableImage root;

        public int getHeight() {
            return 12;
        }

        public int getWidth(@NotNull Font font) {
            MutableComponent consumesText = Component.translatable((String)"description.xycraft.xynergy.consume", (Object[])new Object[]{Component.literal((String)String.valueOf(this.value().amount))});
            return font.width((FormattedText)consumesText) + 10;
        }

        public void renderImage(@NotNull Font font, int _x, int _y, @NotNull GuiGraphics graphics) {
            root.dimensions((float)(font.width(String.valueOf(this.value().amount)) - 1), -2.2f, 12.0f, 12.0f);
            root.color(this.value.full);
            ((DrawableImage)inner.fillParent()).color(this.value.alpha);
            MutableComponent consumesText = Component.translatable((String)"description.xycraft.xynergy.consume", (Object[])new Object[]{Component.literal((String)String.valueOf(this.value().amount)).withColor(this.value.full)});
            graphics.drawString(font, (Component)consumesText.withStyle(ChatFormatting.GRAY), _x, _y, -1);
            root.draw(graphics, (float)(_x + font.width((FormattedText)consumesText) - 6), (float)_y, 0.0, 0.0, 0);
        }

        static {
            root = (DrawableImage)DrawableImage.create().texture(glow).addChild(DrawableImage::create, i -> {
                inner = i;
                inner.texture(bolt);
            });
        }
    }
}

