/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.client;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4f;
import tv.soaryn.xycraft.machines.client.render.XynergyGraphRenderer;
import tv.soaryn.xycraft.machines.content.registries.MachinesAttachments;

public class ClientXynergyGraphCache {
    public static final AttachmentType.Builder<ClientXynergyGraphCache> Builder = AttachmentType.builder(ClientXynergyGraphCache::new);
    private final Long2ObjectMap<LongArrayList> _edges = new Long2ObjectOpenHashMap();
    public final Long2ObjectMap<Vector4f> ColorMap = new Long2ObjectOpenHashMap();

    private ClientXynergyGraphCache() {
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(XynergyGraphRenderer::onRenderLevel);
    }

    @NotNull
    public static ClientXynergyGraphCache of(Level level) {
        return (ClientXynergyGraphCache)level.getData(MachinesAttachments.XynergyClientCache);
    }

    public ObjectSet<Long2ObjectMap.Entry<LongArrayList>> getEdges() {
        return this._edges.long2ObjectEntrySet();
    }

    public LongSet getNodes() {
        Set s = this._edges.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        LongSet keys = this._edges.keySet();
        LongArraySet set = new LongArraySet(s.size() + keys.size());
        set.addAll((LongCollection)keys);
        set.addAll(s);
        return set;
    }

    public void addEdge(long id1, long id2) {
        LongArrayList edgeList;
        long lower = id1;
        long higher = id2;
        if (lower > higher) {
            lower = id2;
            higher = id1;
        }
        if ((edgeList = (LongArrayList)this._edges.get(lower)) == null) {
            edgeList = new LongArrayList();
            edgeList.add(higher);
            this._edges.put(lower, (Object)edgeList);
        } else {
            if (edgeList.contains(higher)) {
                return;
            }
            edgeList.add(higher);
        }
    }

    public void removeEdge(long id1, long id2) {
        LongArrayList list;
        long lower = id1;
        long higher = id2;
        if (lower > higher) {
            lower = id2;
            higher = id1;
        }
        if ((list = (LongArrayList)this._edges.get(lower)) == null) {
            return;
        }
        list.rem(higher);
        if (list.isEmpty()) {
            this._edges.remove(lower);
        }
    }
}

