/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;

public record SyncClientInfoPayload(int slotIndex, @Nullable CompoundTag renderInfoNbt, int columnsTaken) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncClientInfoPayload> TYPE = new CustomPacketPayload.Type(SophisticatedBackpacks.getRL("sync_client_info"));
    public static final StreamCodec<ByteBuf, SyncClientInfoPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SyncClientInfoPayload::slotIndex, (StreamCodec)StreamCodecHelper.ofNullable((StreamCodec)ByteBufCodecs.COMPOUND_TAG), SyncClientInfoPayload::renderInfoNbt, (StreamCodec)ByteBufCodecs.INT, SyncClientInfoPayload::columnsTaken, SyncClientInfoPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(SyncClientInfoPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (payload.renderInfoNbt == null || !(player.containerMenu instanceof BackpackContainer)) {
            return;
        }
        ItemStack backpack = (ItemStack)player.getInventory().items.get(payload.slotIndex);
        IBackpackWrapper backpackWrapper = BackpackWrapper.fromStack(backpack);
        backpackWrapper.getRenderInfo().deserializeFrom((HolderLookup.Provider)player.level().registryAccess(), payload.renderInfoNbt);
        backpackWrapper.setColumnsTaken(payload.columnsTaken, false);
    }
}

