/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.data.SBInjectLootSubProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.data.SBLootEnabledCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;

public class SBLootModifierProvider
extends GlobalLootModifierProvider {
    SBLootModifierProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries, "sophisticatedbackpacks");
    }

    protected void start() {
        this.addInjectLootTableModifier(SBInjectLootSubProvider.SIMPLE_DUNGEON, (ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.ABANDONED_MINESHAFT, (ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.DESERT_PYRAMID, (ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.WOODLAND_MANSION, (ResourceKey<LootTable>)BuiltInLootTables.WOODLAND_MANSION);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.SHIPWRECK_TREASURE, (ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_TREASURE);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.BASTION_TREASURE, (ResourceKey<LootTable>)BuiltInLootTables.BASTION_TREASURE);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.END_CITY_TREASURE, (ResourceKey<LootTable>)BuiltInLootTables.END_CITY_TREASURE);
        this.addInjectLootTableModifier(SBInjectLootSubProvider.NETHER_BRIDGE, (ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE);
    }

    private void addInjectLootTableModifier(ResourceKey<LootTable> lootTable, ResourceKey<LootTable> lootTableToInjectInto) {
        this.add(lootTableToInjectInto.location().getPath(), (IGlobalLootModifier)new InjectLootModifier(lootTable, lootTableToInjectInto), new ICondition[0]);
    }

    public static class InjectLootModifier
    extends LootModifier {
        public static final MapCodec<InjectLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(m -> m.lootTable), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table_to_inject_into").forGetter(m -> m.lootTableToInjectInto))).apply((Applicative)inst, InjectLootModifier::new));
        private final ResourceKey<LootTable> lootTable;
        private final ResourceKey<LootTable> lootTableToInjectInto;

        protected InjectLootModifier(LootItemCondition[] conditions, ResourceKey<LootTable> lootTable, ResourceKey<LootTable> lootTableToInjectInto) {
            super(conditions);
            this.lootTable = lootTable;
            this.lootTableToInjectInto = lootTableToInjectInto;
        }

        protected InjectLootModifier(ResourceKey<LootTable> lootTable, ResourceKey<LootTable> lootTableToInjectInto) {
            this(new LootItemCondition[]{SBLootEnabledCondition.builder().build(), LootTableIdCondition.builder((ResourceLocation)lootTableToInjectInto.location()).build()}, lootTable, lootTableToInjectInto);
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            context.getResolver().get(Registries.LOOT_TABLE, this.lootTable).ifPresent(extraTable -> ((LootTable)extraTable.value()).getRandomItemsRaw(context, LootTable.createStackSplitter((ServerLevel)context.getLevel(), arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0))));
            return generatedLoot;
        }

        public MapCodec<? extends IGlobalLootModifier> codec() {
            return ModItems.INJECT_LOOT.get();
        }
    }
}

