/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.ClientHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;

public class BackpackItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private final Minecraft minecraft = Minecraft.getInstance();

    public BackpackItemStackRenderer(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        matrixStack.popPose();
        matrixStack.pushPose();
        ItemRenderer itemRenderer = this.minecraft.getItemRenderer();
        BakedModel model = itemRenderer.getModel(stack, null, (LivingEntity)this.minecraft.player, 0);
        boolean leftHand = this.minecraft.player != null && this.minecraft.player.getOffhandItem() == stack;
        model = ClientHooks.handleCameraTransforms((PoseStack)matrixStack, (BakedModel)model, (ItemDisplayContext)transformType, (boolean)leftHand);
        matrixStack.translate(-0.5, -0.5, -0.5);
        model.getRenderPasses(stack, true).forEach(bakedModel -> bakedModel.getRenderTypes(stack, true).forEach(renderType -> {
            VertexConsumer ivertexbuilder = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)stack.hasFoil());
            itemRenderer.renderModelLists(bakedModel, stack, combinedLight, combinedOverlay, matrixStack, ivertexbuilder);
            IBackpackWrapper backpackWrapper = BackpackWrapper.fromStack(stack);
            backpackWrapper.getRenderInfo().getItemDisplayRenderInfo().getDisplayItem().ifPresent(displayItem -> {
                matrixStack.translate(0.5, 0.6, 0.25);
                matrixStack.scale(0.5f, 0.5f, 0.5f);
                matrixStack.mulPose(Axis.ZP.rotationDegrees((float)displayItem.getRotation()));
                itemRenderer.renderStatic(displayItem.getItem(), ItemDisplayContext.FIXED, combinedLight, combinedOverlay, matrixStack, buffer, (Level)this.minecraft.level, 0);
            });
        }));
    }
}

